/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.util.Collection;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final Text HDFS_DELEGATION_TOKEN_KIND = new Text("HDFS_DELEGATION_TOKEN");

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration flinkConfiguration) {
        String hadoopConfDir;
        String hadoopConfigPath;
        String hdfsSitePath;
        HdfsConfiguration result = new HdfsConfiguration();
        boolean foundHadoopConfiguration = false;
        String[] possibleHadoopConfPaths = new String[2];
        String hadoopHome = System.getenv("HADOOP_HOME");
        if (hadoopHome != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)hadoopHome);
            possibleHadoopConfPaths[0] = hadoopHome + "/conf";
            possibleHadoopConfPaths[1] = hadoopHome + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null) continue;
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((org.apache.hadoop.conf.Configuration)result, possibleHadoopConfPath);
        }
        String hdfsDefaultPath = flinkConfiguration.getString("fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            result.addResource(new Path(hdfsDefaultPath));
            LOG.debug("Using hdfs-default configuration-file path from Flink config: {}", (Object)hdfsDefaultPath);
            foundHadoopConfiguration = true;
        }
        if ((hdfsSitePath = flinkConfiguration.getString("fs.hdfs.hdfssite", null)) != null) {
            result.addResource(new Path(hdfsSitePath));
            LOG.debug("Using hdfs-site configuration-file path from Flink config: {}", (Object)hdfsSitePath);
            foundHadoopConfiguration = true;
        }
        if ((hadoopConfigPath = flinkConfiguration.getString("fs.hdfs.hadoopconf", null)) != null) {
            LOG.debug("Searching Hadoop configuration files in Flink config: {}", (Object)hadoopConfigPath);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((org.apache.hadoop.conf.Configuration)result, hadoopConfigPath) || foundHadoopConfiguration;
        }
        if ((hadoopConfDir = System.getenv("HADOOP_CONF_DIR")) != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)hadoopConfDir);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((org.apache.hadoop.conf.Configuration)result, hadoopConfDir) || foundHadoopConfiguration;
        }
        if (!foundHadoopConfiguration) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods (Flink configuration, environment variables).");
        }
        return result;
    }

    public static boolean isCredentialsConfigured(UserGroupInformation ugi, boolean useTicketCache) throws Exception {
        if (UserGroupInformation.isSecurityEnabled() && useTicketCache && !ugi.hasKerberosCredentials()) {
            if (!HadoopUtils.hasHDFSDelegationToken()) {
                LOG.error("Hadoop security is enabled, but current login user has neither Kerberos credentials nor delegation tokens!");
                return false;
            }
            LOG.warn("Hadoop security is enabled but current login user does not have Kerberos credentials, use delegation token instead. Flink application will terminate after token expires.");
        }
        return true;
    }

    public static boolean hasHDFSDelegationToken() throws Exception {
        UserGroupInformation loginUser = UserGroupInformation.getCurrentUser();
        Collection usrTok = loginUser.getTokens();
        for (Token token : usrTok) {
            if (!token.getKind().equals((Object)HDFS_DELEGATION_TOKEN_KIND)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMinHadoopVersion(int major, int minor) throws FlinkRuntimeException {
        Tuple2<Integer, Integer> hadoopVersion = HadoopUtils.getMajorMinorBundledHadoopVersion();
        int maj = (Integer)hadoopVersion.f0;
        int min = (Integer)hadoopVersion.f1;
        return maj > major || maj == major && min >= minor;
    }

    public static boolean isMaxHadoopVersion(int major, int minor) throws FlinkRuntimeException {
        Tuple2<Integer, Integer> hadoopVersion = HadoopUtils.getMajorMinorBundledHadoopVersion();
        int maj = (Integer)hadoopVersion.f0;
        int min = (Integer)hadoopVersion.f1;
        return maj < major || maj == major && min < minor;
    }

    private static Tuple2<Integer, Integer> getMajorMinorBundledHadoopVersion() {
        String versionString = VersionInfo.getVersion();
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length < 2) {
            throw new FlinkRuntimeException("Cannot determine version of Hadoop, unexpected version string: " + versionString);
        }
        int maj = Integer.parseInt(versionParts[0]);
        int min = Integer.parseInt(versionParts[1]);
        return Tuple2.of((Object)maj, (Object)min);
    }

    private static boolean addHadoopConfIfFound(org.apache.hadoop.conf.Configuration configuration, String possibleHadoopConfPath) {
        boolean foundHadoopConfiguration = false;
        if (new File(possibleHadoopConfPath).exists()) {
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
            if (new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
        }
        return foundHadoopConfiguration;
    }
}

