/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoopcompatibility.mapred.wrapper;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.operators.translation.TupleUnwrappingIterator;
import org.apache.flink.api.java.tuple.Tuple2;

public class HadoopTupleUnwrappingIterator<KEY, VALUE>
extends TupleUnwrappingIterator<VALUE, KEY>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Iterator<Tuple2<KEY, VALUE>> iterator;
    private final TypeSerializer<KEY> keySerializer;
    private boolean atFirst = false;
    private KEY curKey = null;
    private VALUE firstValue = null;

    public HadoopTupleUnwrappingIterator(TypeSerializer<KEY> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void set(Iterator<Tuple2<KEY, VALUE>> iterator) {
        this.iterator = iterator;
        if (this.hasNext()) {
            Tuple2<KEY, VALUE> tuple = iterator.next();
            this.curKey = this.keySerializer.copy(tuple.f0);
            this.firstValue = tuple.f1;
            this.atFirst = true;
        } else {
            this.atFirst = false;
        }
    }

    public boolean hasNext() {
        if (this.atFirst) {
            return true;
        }
        return this.iterator.hasNext();
    }

    public VALUE next() {
        if (this.atFirst) {
            this.atFirst = false;
            return this.firstValue;
        }
        Tuple2<KEY, VALUE> tuple = this.iterator.next();
        return (VALUE)tuple.f1;
    }

    public KEY getCurrentKey() {
        return this.curKey;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

