/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.AutoValue_CredentialOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

@AutoValue
public abstract class CredentialOptions {
    static final boolean SERVICE_ACCOUNT_ENABLED_DEFAULT = true;
    static final boolean NULL_CREDENTIALS_ENABLED_DEFAULT = false;
    static final HttpTransportFactory.HttpTransportType HTTP_TRANSPORT_TYPE_DEFAULT = HttpTransportFactory.DEFAULT_TRANSPORT_TYPE;
    static final String TOKEN_SERVER_URL_DEFAULT = "https://oauth2.googleapis.com/token";

    public static Builder builder() {
        return new AutoValue_CredentialOptions.Builder().setServiceAccountEnabled(true).setNullCredentialEnabled(false).setTransportType(HTTP_TRANSPORT_TYPE_DEFAULT).setTokenServerUrl(TOKEN_SERVER_URL_DEFAULT);
    }

    public abstract Builder toBuilder();

    public abstract boolean isServiceAccountEnabled();

    @Nullable
    public abstract RedactedString getServiceAccountPrivateKeyId();

    @Nullable
    public abstract RedactedString getServiceAccountPrivateKey();

    @Nullable
    public abstract String getServiceAccountEmail();

    @Nullable
    public abstract String getServiceAccountKeyFile();

    @Nullable
    public abstract String getServiceAccountJsonKeyFile();

    public abstract boolean isNullCredentialEnabled();

    public abstract HttpTransportFactory.HttpTransportType getTransportType();

    public abstract String getTokenServerUrl();

    @Nullable
    public abstract String getProxyAddress();

    @Nullable
    public abstract RedactedString getProxyUsername();

    @Nullable
    public abstract RedactedString getProxyPassword();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setServiceAccountEnabled(boolean var1);

        public abstract Builder setServiceAccountPrivateKeyId(RedactedString var1);

        public abstract Builder setServiceAccountPrivateKey(RedactedString var1);

        public abstract Builder setServiceAccountEmail(String var1);

        public abstract Builder setServiceAccountKeyFile(String var1);

        public abstract Builder setServiceAccountJsonKeyFile(String var1);

        public abstract Builder setNullCredentialEnabled(boolean var1);

        public abstract Builder setTransportType(HttpTransportFactory.HttpTransportType var1);

        public abstract Builder setTokenServerUrl(String var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setProxyUsername(RedactedString var1);

        public abstract Builder setProxyPassword(RedactedString var1);

        abstract CredentialOptions autoBuild();

        public CredentialOptions build() {
            CredentialOptions options = this.autoBuild();
            if (options.isServiceAccountEnabled()) {
                if (options.getServiceAccountPrivateKeyId() != null) {
                    Preconditions.checkArgument(options.getServiceAccountPrivateKey() != null, "privateKeyId must be set if using credentials configured directly in configuration.");
                    Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getServiceAccountEmail()), "clientEmail must be set if using credentials configured directly in configuration.");
                    Preconditions.checkArgument(Strings.isNullOrEmpty(options.getServiceAccountKeyFile()), "A P12 key file may not be specified at the same time as credentials via configuration.");
                    Preconditions.checkArgument(Strings.isNullOrEmpty(options.getServiceAccountJsonKeyFile()), "A JSON key file may not be specified at the same time as credentials via configuration.");
                }
                if (!Strings.isNullOrEmpty(options.getServiceAccountJsonKeyFile())) {
                    Preconditions.checkArgument(Strings.isNullOrEmpty(options.getServiceAccountKeyFile()), "A P12 key file may not be specified at the same time as a JSON key file.");
                    Preconditions.checkArgument(Strings.isNullOrEmpty(options.getServiceAccountEmail()), "Service account email may not be specified at the same time as a JSON key file.");
                }
                if (!Strings.isNullOrEmpty(options.getServiceAccountKeyFile())) {
                    Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getServiceAccountEmail()), "Email must be set if using service account auth and a key file is specified.");
                }
            } else {
                Preconditions.checkArgument(options.isNullCredentialEnabled(), "No valid credential configuration discovered: ", (Object)options);
            }
            return options;
        }
    }
}

