/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.scala.examples;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.examples.data.SingleSourceShortestPathsData;
import org.apache.flink.graph.scala.Graph;
import org.apache.flink.graph.scala.Graph$;
import org.apache.flink.graph.scala.examples.SingleSourceShortestPaths;
import org.apache.flink.graph.scala.examples.SingleSourceShortestPaths$;
import org.apache.flink.graph.scala.utils.Tuple3ToEdgeMap;
import org.apache.flink.graph.spargel.MessagingFunction;
import org.apache.flink.graph.spargel.VertexUpdateFunction;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SingleSourceShortestPaths$ {
    public static final SingleSourceShortestPaths$ MODULE$;
    private boolean fileOutput;
    private long srcVertexId;
    private String edgesInputPath;
    private String outputPath;
    private int maxIterations;

    static {
        new SingleSourceShortestPaths$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet<Edge<Object, Object>> edges = this.getEdgesDataSet(env);
            Graph graph = Graph$.MODULE$.fromDataSet(edges, (MapFunction)new SingleSourceShortestPaths.InitVertices(this.srcVertexId()), env, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long(), (TypeInformation)BasicTypeInfo.getInfoFor(Double.TYPE), ClassTag$.MODULE$.Double(), (TypeInformation)BasicTypeInfo.getInfoFor(Double.TYPE), ClassTag$.MODULE$.Double());
            Graph result = graph.runScatterGatherIteration((VertexUpdateFunction)new SingleSourceShortestPaths.VertexDistanceUpdater(), (MessagingFunction)new SingleSourceShortestPaths.MinDistanceMessenger(), this.maxIterations());
            DataSet singleSourceShortestPaths = result.getVertices();
            if (this.fileOutput()) {
                singleSourceShortestPaths.writeAsCsv(this.outputPath(), "\n", ",", singleSourceShortestPaths.writeAsCsv$default$4());
                env.execute("Single Source Shortest Paths Example");
            } else {
                singleSourceShortestPaths.print();
            }
            return;
        }
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private long srcVertexId() {
        return this.srcVertexId;
    }

    private void srcVertexId_$eq(long x$1) {
        this.srcVertexId = x$1;
    }

    private String edgesInputPath() {
        return this.edgesInputPath;
    }

    private void edgesInputPath_$eq(String x$1) {
        this.edgesInputPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 4) {
                System.err.println("Usage: SingleSourceShortestPaths <source vertex id> <input edges path> <output path> <num iterations>");
            }
            this.fileOutput_$eq(true);
            this.srcVertexId_$eq(new StringOps(Predef$.MODULE$.augmentString(args[0])).toLong());
            this.edgesInputPath_$eq(args[1]);
            this.outputPath_$eq(args[2]);
            this.maxIterations_$eq(3);
        } else {
            System.out.println("Executing Single Source Shortest Paths example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("Usage: SingleSourceShortestPaths <source vertex id> <input edges path> <output path> <num iterations>");
        }
        return true;
    }

    private DataSet<Edge<Object, Object>> getEdgesDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            List fields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicTypeInfo[]{BasicTypeInfo.getInfoFor(Long.TYPE), BasicTypeInfo.getInfoFor(Long.TYPE), BasicTypeInfo.getInfoFor(Double.TYPE)}));
            Class<Edge> clazz = Edge.class;
            dataSet = env.readCsvFile(this.edgesInputPath(), "\n", "\t", env.readCsvFile$default$4(), env.readCsvFile$default$5(), env.readCsvFile$default$6(), env.readCsvFile$default$7(), env.readCsvFile$default$8(), env.readCsvFile$default$9(), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.3 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.3 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                        public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                        }
                    };
                }
            }).map((MapFunction)new Tuple3ToEdgeMap(), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))), ClassTag$.MODULE$.apply(Edge.class));
        } else {
            Tuple3[] edgeData = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])SingleSourceShortestPathsData.DEFAULT_EDGES).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, Object, Object> apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        Object z = ((SeqLike)option.get()).apply(2);
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x)), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)y)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)z)));
                        return tuple3;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            List fields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicTypeInfo[]{BasicTypeInfo.getInfoFor(Long.TYPE), BasicTypeInfo.getInfoFor(Long.TYPE), BasicTypeInfo.getInfoFor(Double.TYPE)}));
            Class<Edge> clazz = Edge.class;
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])edgeData), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.4 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.4 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                        public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                        }
                    };
                }
            }).map((MapFunction)new Tuple3ToEdgeMap(), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))), ClassTag$.MODULE$.apply(Edge.class));
        }
        return dataSet;
    }

    private SingleSourceShortestPaths$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.srcVertexId = 1L;
        this.edgesInputPath = null;
        this.outputPath = null;
        this.maxIterations = 5;
    }
}

