/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.scala.examples;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.scala.Graph;
import org.apache.flink.graph.scala.Graph$;
import org.apache.flink.graph.scala.examples.GraphMetrics$;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GraphMetrics$ {
    public static final GraphMetrics$ MODULE$;
    private boolean fileOutput;
    private String edgesPath;
    private String outputPath;
    private final int org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices;

    static {
        new GraphMetrics$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            Graph graph = Graph$.MODULE$.fromDataSet(this.getEdgeDataSet(env), env, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long(), (TypeInformation)new ValueTypeInfo(NullValue.class), ClassTag$.MODULE$.apply(NullValue.class));
            long numVertices = graph.numberOfVertices();
            long numEdges = graph.numberOfEdges();
            DataSet verticesWithDegrees = graph.getDegrees();
            DataSet avgDegree = verticesWithDegrees.sum(1).map((Function1)new Serializable(numVertices){
                public static final long serialVersionUID = 0L;
                private final long numVertices$1;

                public final double apply(Tuple2<Object, Object> in) {
                    return in._2$mcJ$sp() / this.numVertices$1;
                }
                {
                    this.numVertices$1 = numVertices$1;
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Double.TYPE), ClassTag$.MODULE$.Double());
            DataSet maxInDegreeVertex = graph.inDegrees().max(1).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> in) {
                    return in._1$mcJ$sp();
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
            DataSet minInDegreeVertex = graph.inDegrees().min(1).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> in) {
                    return in._1$mcJ$sp();
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
            DataSet maxOutDegreeVertex = graph.outDegrees().max(1).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> in) {
                    return in._1$mcJ$sp();
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
            DataSet minOutDegreeVertex = graph.outDegrees().min(1).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> in) {
                    return in._1$mcJ$sp();
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
            env.fromElements((Seq)Predef$.MODULE$.wrapLongArray(new long[]{numVertices}), ClassTag$.MODULE$.Long(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).printOnTaskManager("Total number of vertices");
            env.fromElements((Seq)Predef$.MODULE$.wrapLongArray(new long[]{numEdges}), ClassTag$.MODULE$.Long(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).printOnTaskManager("Total number of edges");
            avgDegree.printOnTaskManager("Average node degree");
            maxInDegreeVertex.printOnTaskManager("Vertex with Max in-degree");
            minInDegreeVertex.printOnTaskManager("Vertex with Max in-degree");
            maxOutDegreeVertex.printOnTaskManager("Vertex with Max out-degree");
            minOutDegreeVertex.printOnTaskManager("Vertex with Max out-degree");
            return;
        }
    }

    private boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length > 0) {
            this.fileOutput_$eq(true);
            if (args.length == 1) {
                this.edgesPath_$eq(args[0]);
                bl = true;
            } else {
                System.err.println("Usage: GraphMetrics <edges path>");
                bl = false;
            }
        } else {
            System.out.println("Executing GraphMetrics example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: GraphMetrics <edges path>");
            bl = true;
        }
        return bl;
    }

    private DataSet<Edge<Object, NullValue>> getEdgeDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$1 = this.edgesPath();
            String x$2 = "\t";
            String x$3 = env.readCsvFile$default$2();
            Character x$4 = env.readCsvFile$default$4();
            boolean x$5 = env.readCsvFile$default$5();
            String x$6 = env.readCsvFile$default$6();
            boolean x$7 = env.readCsvFile$default$7();
            int[] x$8 = env.readCsvFile$default$8();
            String[] x$9 = env.readCsvFile$default$9();
            List fields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeInformation[]{BasicTypeInfo.getInfoFor(Long.TYPE), BasicTypeInfo.getInfoFor(Long.TYPE), new ValueTypeInfo(NullValue.class)}));
            Class<Edge> clazz = Edge.class;
            dataSet = env.readCsvFile(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.2 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.2 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Edge<Object, NullValue> apply(Tuple2<Object, Object> in) {
                    return new Edge((Object)BoxesRunTime.boxToLong((long)in._1$mcJ$sp()), (Object)BoxesRunTime.boxToLong((long)in._2$mcJ$sp()), (Object)NullValue.getInstance());
                }
            }, (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(TypeInformation.class))), ClassTag$.MODULE$.apply(Edge.class));
        } else {
            List fields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeInformation[]{BasicTypeInfo.getInfoFor(Long.TYPE), BasicTypeInfo.getInfoFor(Long.TYPE), new ValueTypeInfo(NullValue.class)}));
            Class<Edge> clazz = Edge.class;
            dataSet = env.generateSequence(1L, (long)this.org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices()).flatMap((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(long key, Collector<Edge<Object, NullValue>> out) {
                    int numOutEdges = (int)(Math.random() * (double)(GraphMetrics$.MODULE$.org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices() / 2));
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numOutEdges).foreach((Function1)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final long key$1;

                        public final Edge<Object, NullValue> apply(int i) {
                            long target = (long)(Math.random() * (double)GraphMetrics$.MODULE$.org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices() + 1.0);
                            return new Edge((Object)BoxesRunTime.boxToLong((long)this.key$1), (Object)BoxesRunTime.boxToLong((long)target), (Object)NullValue.getInstance());
                        }
                        {
                            this.key$1 = key$1;
                        }
                    });
                }
            }, (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(TypeInformation.class))), ClassTag$.MODULE$.apply(Edge.class));
        }
        return dataSet;
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String edgesPath() {
        return this.edgesPath;
    }

    private void edgesPath_$eq(String x$1) {
        this.edgesPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    public int org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices() {
        return this.org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices;
    }

    private GraphMetrics$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.edgesPath = null;
        this.outputPath = null;
        this.org$apache$flink$graph$scala$examples$GraphMetrics$$numVertices = 100;
    }
}

