/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;

public class ExampleUtils {
    public static void printResult(DataSet set, String msg) {
        set.output((OutputFormat)new PrintingOutputFormatWithMessage(msg){});
    }

    public static DataSet<Vertex<Long, NullValue>> getVertexIds(ExecutionEnvironment env, long numVertices) {
        return env.generateSequence(1L, numVertices).map((MapFunction)new MapFunction<Long, Vertex<Long, NullValue>>(){

            public Vertex<Long, NullValue> map(Long l) {
                return new Vertex((Object)l, (Object)NullValue.getInstance());
            }
        });
    }

    public static DataSet<Edge<Long, NullValue>> getRandomEdges(ExecutionEnvironment env, final long numVertices) {
        return env.generateSequence(1L, numVertices).flatMap((FlatMapFunction)new FlatMapFunction<Long, Edge<Long, NullValue>>(){

            public void flatMap(Long key, Collector<Edge<Long, NullValue>> out) throws Exception {
                int numOutEdges = (int)(Math.random() * (double)(numVertices / 2L));
                for (int i = 0; i < numOutEdges; ++i) {
                    long target = (long)(Math.random() * (double)numVertices) + 1L;
                    out.collect((Object)new Edge((Object)key, (Object)target, (Object)NullValue.getInstance()));
                }
            }
        });
    }

    public static DataSet<Vertex<Long, Double>> getLongDoubleVertexData(ExecutionEnvironment env) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(new Vertex((Object)1L, (Object)1.0));
        vertices.add(new Vertex((Object)2L, (Object)2.0));
        vertices.add(new Vertex((Object)3L, (Object)3.0));
        vertices.add(new Vertex((Object)4L, (Object)4.0));
        vertices.add(new Vertex((Object)5L, (Object)5.0));
        return env.fromCollection(vertices);
    }

    public static DataSet<Edge<Long, Double>> getLongDoubleEdgeData(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)2L, (Object)12.0));
        edges.add(new Edge((Object)1L, (Object)3L, (Object)13.0));
        edges.add(new Edge((Object)2L, (Object)3L, (Object)23.0));
        edges.add(new Edge((Object)3L, (Object)4L, (Object)34.0));
        edges.add(new Edge((Object)3L, (Object)5L, (Object)35.0));
        edges.add(new Edge((Object)4L, (Object)5L, (Object)45.0));
        edges.add(new Edge((Object)5L, (Object)1L, (Object)51.0));
        return env.fromCollection(edges);
    }

    private ExampleUtils() {
        throw new RuntimeException();
    }

    public static class PrintingOutputFormatWithMessage<T>
    implements OutputFormat<T> {
        private static final long serialVersionUID = 1L;
        private transient PrintStream stream;
        private transient String prefix;
        private String message;

        public PrintingOutputFormatWithMessage() {
        }

        public PrintingOutputFormatWithMessage(String msg) {
            this.message = msg;
        }

        public void open(int taskNumber, int numTasks) {
            this.stream = System.out;
            this.prefix = this.message + ": ";
        }

        public void writeRecord(T record) {
            if (this.prefix != null) {
                this.stream.println(this.prefix + record.toString());
            } else {
                this.stream.println(record.toString());
            }
        }

        public void close() {
            this.stream = null;
            this.prefix = null;
        }

        public String toString() {
            return "Print to System.out";
        }

        public void configure(Configuration parameters) {
        }
    }
}

