/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples.data;

import java.util.ArrayList;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.types.NullValue;

public class SummarizationData {
    public static final String[] EXPECTED_VERTICES = new String[]{"0,1;A,2", "2,3,4;B,3", "5;C,1"};
    public static final String[] EXPECTED_EDGES_WITH_VALUES = new String[]{"0,1;0,1;A,2", "0,1;2,3,4;A,1", "2,3,4;0,1;A,1", "2,3,4;0,1;C,2", "2,3,4;2,3,4;B,2", "5;2,3,4;D,2"};
    public static final String[] EXPECTED_EDGES_ABSENT_VALUES = new String[]{"0,1;0,1;(null),2", "0,1;2,3,4;(null),1", "2,3,4;0,1;(null),3", "2,3,4;2,3,4;(null),2", "5;2,3,4;(null),2"};

    private SummarizationData() {
    }

    public static DataSet<Vertex<Long, String>> getVertices(ExecutionEnvironment env) {
        ArrayList<Vertex> vertices = Lists.newArrayListWithExpectedSize(6);
        vertices.add(new Vertex((Object)0L, (Object)"A"));
        vertices.add(new Vertex((Object)1L, (Object)"A"));
        vertices.add(new Vertex((Object)2L, (Object)"B"));
        vertices.add(new Vertex((Object)3L, (Object)"B"));
        vertices.add(new Vertex((Object)4L, (Object)"B"));
        vertices.add(new Vertex((Object)5L, (Object)"C"));
        return env.fromCollection(vertices);
    }

    public static DataSet<Edge<Long, String>> getEdges(ExecutionEnvironment env) {
        ArrayList<Edge> edges = Lists.newArrayListWithExpectedSize(10);
        edges.add(new Edge((Object)0L, (Object)1L, (Object)"A"));
        edges.add(new Edge((Object)1L, (Object)0L, (Object)"A"));
        edges.add(new Edge((Object)1L, (Object)2L, (Object)"A"));
        edges.add(new Edge((Object)2L, (Object)1L, (Object)"A"));
        edges.add(new Edge((Object)2L, (Object)3L, (Object)"B"));
        edges.add(new Edge((Object)3L, (Object)2L, (Object)"B"));
        edges.add(new Edge((Object)4L, (Object)0L, (Object)"C"));
        edges.add(new Edge((Object)4L, (Object)1L, (Object)"C"));
        edges.add(new Edge((Object)5L, (Object)2L, (Object)"D"));
        edges.add(new Edge((Object)5L, (Object)3L, (Object)"D"));
        return env.fromCollection(edges);
    }

    public static DataSet<Edge<Long, NullValue>> getEdgesWithAbsentValues(ExecutionEnvironment env) {
        return SummarizationData.getEdges(env).map((MapFunction)new MapFunction<Edge<Long, String>, Edge<Long, NullValue>>(){

            public Edge<Long, NullValue> map(Edge<Long, String> value) throws Exception {
                return new Edge(value.getSource(), value.getTarget(), (Object)NullValue.getInstance());
            }
        });
    }
}

