/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples.data;

import java.util.ArrayList;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;

public class IncrementalSSSPData {
    public static final int NUM_VERTICES = 5;
    public static final String VERTICES = "1,6.0\n2,2.0\n3,3.0\n4,1.0\n5,0.0";
    public static final String EDGES = "1,3,3.0\n2,4,3.0\n2,5,2.0\n3,2,1.0\n3,5,5.0\n4,5,1.0";
    public static final String EDGES_IN_SSSP = "1,3,3.0\n2,5,2.0\n3,2,1.0\n4,5,1.0";
    public static final String SRC_EDGE_TO_BE_REMOVED = "2";
    public static final String TRG_EDGE_TO_BE_REMOVED = "5";
    public static final String VAL_EDGE_TO_BE_REMOVED = "2.0";
    public static final String RESULTED_VERTICES = "1,1.7976931348623157E308\n2,1.7976931348623157E308\n3,1.7976931348623157E308\n4,1.0\n5,0.0";

    public static DataSet<Vertex<Long, Double>> getDefaultVertexDataSet(ExecutionEnvironment env) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(new Vertex((Object)1L, (Object)6.0));
        vertices.add(new Vertex((Object)2L, (Object)2.0));
        vertices.add(new Vertex((Object)3L, (Object)3.0));
        vertices.add(new Vertex((Object)4L, (Object)1.0));
        vertices.add(new Vertex((Object)5L, (Object)0.0));
        return env.fromCollection(vertices);
    }

    public static final DataSet<Edge<Long, Double>> getDefaultEdgeDataSet(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)3L, (Object)3.0));
        edges.add(new Edge((Object)2L, (Object)4L, (Object)3.0));
        edges.add(new Edge((Object)2L, (Object)5L, (Object)2.0));
        edges.add(new Edge((Object)3L, (Object)2L, (Object)1.0));
        edges.add(new Edge((Object)3L, (Object)5L, (Object)5.0));
        edges.add(new Edge((Object)4L, (Object)5L, (Object)1.0));
        return env.fromCollection(edges);
    }

    public static final DataSet<Edge<Long, Double>> getDefaultEdgesInSSSP(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(new Edge((Object)1L, (Object)3L, (Object)3.0));
        edges.add(new Edge((Object)2L, (Object)5L, (Object)2.0));
        edges.add(new Edge((Object)3L, (Object)2L, (Object)1.0));
        edges.add(new Edge((Object)4L, (Object)5L, (Object)1.0));
        return env.fromCollection(edges);
    }

    public static final Edge<Long, Double> getDefaultEdgeToBeRemoved() {
        return new Edge((Object)2L, (Object)5L, (Object)2.0);
    }

    private IncrementalSSSPData() {
    }
}

