/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import java.util.Iterator;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.examples.data.SingleSourceShortestPathsData;
import org.apache.flink.graph.spargel.MessageIterator;
import org.apache.flink.graph.spargel.MessagingFunction;
import org.apache.flink.graph.spargel.VertexUpdateFunction;
import org.apache.flink.graph.utils.Tuple3ToEdgeMap;

public class SingleSourceShortestPaths
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static Long srcVertexId = 1L;
    private static String edgesInputPath = null;
    private static String outputPath = null;
    private static int maxIterations = 5;

    public static void main(String[] args) throws Exception {
        if (!SingleSourceShortestPaths.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Edge<Long, Double>> edges = SingleSourceShortestPaths.getEdgesDataSet(env);
        Graph graph = Graph.fromDataSet(edges, (MapFunction)new InitVertices(srcVertexId), (ExecutionEnvironment)env);
        Graph result = graph.runScatterGatherIteration((VertexUpdateFunction)new VertexDistanceUpdater(), (MessagingFunction)new MinDistanceMessenger(), maxIterations);
        DataSet singleSourceShortestPaths = result.getVertices();
        if (fileOutput) {
            singleSourceShortestPaths.writeAsCsv(outputPath, "\n", ",");
            env.execute("Single Source Shortest Paths Example");
        } else {
            singleSourceShortestPaths.print();
        }
    }

    private static boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 4) {
                System.err.println("Usage: SingleSourceShortestPaths <source vertex id> <input edges path> <output path> <num iterations>");
                return false;
            }
            fileOutput = true;
            srcVertexId = Long.parseLong(args[0]);
            edgesInputPath = args[1];
            outputPath = args[2];
            maxIterations = Integer.parseInt(args[3]);
        } else {
            System.out.println("Executing Single Source Shortest Paths example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("Usage: SingleSourceShortestPaths <source vertex id> <input edges path> <output path> <num iterations>");
        }
        return true;
    }

    private static DataSet<Edge<Long, Double>> getEdgesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgesInputPath).lineDelimiter("\n").fieldDelimiter("\t").types(Long.class, Long.class, Double.class).map((MapFunction)new Tuple3ToEdgeMap());
        }
        return SingleSourceShortestPathsData.getDefaultEdgeDataSet(env);
    }

    public String getDescription() {
        return "Scatter-gather Single Source Shortest Paths";
    }

    public static final class MinDistanceMessenger
    extends MessagingFunction<Long, Double, Double, Double> {
        public void sendMessages(Vertex<Long, Double> vertex) {
            if ((Double)vertex.getValue() < Double.POSITIVE_INFINITY) {
                for (Edge edge : this.getEdges()) {
                    this.sendMessageTo(edge.getTarget(), (Double)vertex.getValue() + (Double)edge.getValue());
                }
            }
        }
    }

    public static final class VertexDistanceUpdater
    extends VertexUpdateFunction<Long, Double, Double> {
        public void updateVertex(Vertex<Long, Double> vertex, MessageIterator<Double> inMessages) {
            Double minDistance = Double.MAX_VALUE;
            Iterator i$ = inMessages.iterator();
            while (i$.hasNext()) {
                double msg = (Double)i$.next();
                if (!(msg < minDistance)) continue;
                minDistance = msg;
            }
            if ((Double)vertex.getValue() > minDistance) {
                this.setNewVertexValue(minDistance);
            }
        }
    }

    private static final class InitVertices
    implements MapFunction<Long, Double> {
        private long srcId;

        public InitVertices(long srcId) {
            this.srcId = srcId;
        }

        public Double map(Long id) {
            if (id.equals(this.srcId)) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
    }
}

