/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.examples.utils.ExampleUtils;
import org.apache.flink.types.NullValue;

public class GraphMetrics
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static String edgesInputPath = null;
    static final int NUM_VERTICES = 100;
    static final long SEED = 9876L;

    public static void main(String[] args) throws Exception {
        if (!GraphMetrics.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Graph graph = Graph.fromDataSet(GraphMetrics.getEdgesDataSet(env), (ExecutionEnvironment)env);
        long numVertices = graph.numberOfVertices();
        long numEdges = graph.numberOfEdges();
        DataSet verticesWithDegrees = graph.getDegrees();
        MapOperator avgNodeDegree = verticesWithDegrees.aggregate(Aggregations.SUM, 1).map((MapFunction)new AvgNodeDegreeMapper(numVertices));
        MapOperator maxInDegreeVertex = graph.inDegrees().maxBy(new int[]{1}).map((MapFunction)new ProjectVertexId());
        MapOperator minInDegreeVertex = graph.inDegrees().minBy(new int[]{1}).map((MapFunction)new ProjectVertexId());
        MapOperator maxOutDegreeVertex = graph.outDegrees().maxBy(new int[]{1}).map((MapFunction)new ProjectVertexId());
        MapOperator minOutDegreeVertex = graph.outDegrees().minBy(new int[]{1}).map((MapFunction)new ProjectVertexId());
        ExampleUtils.printResult((DataSet)env.fromElements((Object[])new Long[]{numVertices}), "Total number of vertices");
        ExampleUtils.printResult((DataSet)env.fromElements((Object[])new Long[]{numEdges}), "Total number of edges");
        ExampleUtils.printResult((DataSet)avgNodeDegree, "Average node degree");
        ExampleUtils.printResult((DataSet)maxInDegreeVertex, "Vertex with Max in-degree");
        ExampleUtils.printResult((DataSet)minInDegreeVertex, "Vertex with Min in-degree");
        ExampleUtils.printResult((DataSet)maxOutDegreeVertex, "Vertex with Max out-degree");
        ExampleUtils.printResult((DataSet)minOutDegreeVertex, "Vertex with Min out-degree");
        env.execute();
    }

    public String getDescription() {
        return "Graph Metrics Example";
    }

    private static boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 1) {
                System.err.println("Usage: GraphMetrics <input edges>");
                return false;
            }
            fileOutput = true;
            edgesInputPath = args[0];
        } else {
            System.out.println("Executing Graph Metrics example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("Usage: GraphMetrics <input edges>");
        }
        return true;
    }

    private static DataSet<Edge<Long, NullValue>> getEdgesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgesInputPath).lineDelimiter("\n").fieldDelimiter("\t").types(Long.class, Long.class).map((MapFunction)new MapFunction<Tuple2<Long, Long>, Edge<Long, NullValue>>(){

                public Edge<Long, NullValue> map(Tuple2<Long, Long> value) {
                    return new Edge(value.f0, value.f1, (Object)NullValue.getInstance());
                }
            });
        }
        return ExampleUtils.getRandomEdges(env, 100L);
    }

    private static final class ProjectVertexId
    implements MapFunction<Tuple2<Long, Long>, Long> {
        private ProjectVertexId() {
        }

        public Long map(Tuple2<Long, Long> value) {
            return (Long)value.f0;
        }
    }

    private static final class AvgNodeDegreeMapper
    implements MapFunction<Tuple2<Long, Long>, Double> {
        private long numberOfVertices;

        public AvgNodeDegreeMapper(long numberOfVertices) {
            this.numberOfVertices = numberOfVertices;
        }

        public Double map(Tuple2<Long, Long> sumTuple) {
            return (Long)sumTuple.f1 / this.numberOfVertices;
        }
    }
}

