/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.examples.data.ConnectedComponentsDefaultData;
import org.apache.flink.graph.library.GSAConnectedComponents;
import org.apache.flink.types.NullValue;

public class ConnectedComponents
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static String edgeInputPath = null;
    private static String outputPath = null;
    private static Integer maxIterations = ConnectedComponentsDefaultData.MAX_ITERATIONS;

    public static void main(String[] args) throws Exception {
        if (!ConnectedComponents.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Edge<Long, NullValue>> edges = ConnectedComponents.getEdgesDataSet(env);
        Graph graph = Graph.fromDataSet(edges, (MapFunction)new MapFunction<Long, Long>(){

            public Long map(Long value) throws Exception {
                return value;
            }
        }, (ExecutionEnvironment)env);
        DataSet verticesWithMinIds = (DataSet)graph.run((GraphAlgorithm)new GSAConnectedComponents(maxIterations));
        if (fileOutput) {
            verticesWithMinIds.writeAsCsv(outputPath, "\n", ",");
            env.execute("Connected Components Example");
        } else {
            verticesWithMinIds.print();
        }
    }

    public String getDescription() {
        return "Connected Components Example";
    }

    private static boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length != 3) {
                System.err.println("Usage ConnectedComponents <edge path> <output path> <num iterations>");
                return false;
            }
            fileOutput = true;
            edgeInputPath = args[0];
            outputPath = args[1];
            maxIterations = Integer.parseInt(args[2]);
        } else {
            System.out.println("Executing ConnectedComponents example with default parameters and built-in default data.");
            System.out.println("Provide parameters to read input data from files.");
            System.out.println("Usage ConnectedComponents <edge path> <output path> <num iterations>");
        }
        return true;
    }

    private static DataSet<Edge<Long, NullValue>> getEdgesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgeInputPath).ignoreComments("#").fieldDelimiter("\t").lineDelimiter("\n").types(Long.class, Long.class).map((MapFunction)new MapFunction<Tuple2<Long, Long>, Edge<Long, NullValue>>(){

                public Edge<Long, NullValue> map(Tuple2<Long, Long> value) throws Exception {
                    return new Edge(value.f0, value.f1, (Object)NullValue.getInstance());
                }
            });
        }
        return ConnectedComponentsDefaultData.getDefaultEdgeDataSet(env);
    }
}

