/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.CompactingFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.WriterProperties;

@Internal
public interface BucketWriter<IN, BucketID> {
    public InProgressFileWriter<IN, BucketID> openNewInProgressFile(BucketID var1, Path var2, long var3) throws IOException;

    default public CompactingFileWriter openNewCompactingFile(CompactingFileWriter.Type type, BucketID bucketID, Path path, long creationTime) throws IOException {
        if (type == CompactingFileWriter.Type.RECORD_WISE) {
            return this.openNewInProgressFile(bucketID, path, creationTime);
        }
        throw new UnsupportedOperationException();
    }

    public InProgressFileWriter<IN, BucketID> resumeInProgressFileFrom(BucketID var1, InProgressFileWriter.InProgressFileRecoverable var2, long var3) throws IOException;

    public WriterProperties getProperties();

    public PendingFile recoverPendingFile(InProgressFileWriter.PendingFileRecoverable var1) throws IOException;

    public boolean cleanupInProgressFileRecoverable(InProgressFileWriter.InProgressFileRecoverable var1) throws IOException;

    public static interface PendingFile {
        public void commit() throws IOException;

        public void commitAfterRecovery() throws IOException;
    }
}

