/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.event;

import org.apache.flink.streaming.examples.statemachine.event.EventType;
import org.apache.flink.util.Preconditions;

public class Event {
    private final EventType type;
    private final int sourceAddress;

    public Event(EventType type, int sourceAddress) {
        this.type = (EventType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.sourceAddress = sourceAddress;
    }

    public EventType type() {
        return this.type;
    }

    public int sourceAddress() {
        return this.sourceAddress;
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.sourceAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Event that = (Event)obj;
        return this.type == that.type && this.sourceAddress == that.sourceAddress;
    }

    public String toString() {
        return "Event " + Event.formatAddress(this.sourceAddress) + " : " + this.type.name();
    }

    public static String formatAddress(int address) {
        int b1 = address >>> 24 & 0xFF;
        int b2 = address >>> 16 & 0xFF;
        int b3 = address >>> 8 & 0xFF;
        int b4 = address & 0xFF;
        return "" + b1 + '.' + b2 + '.' + b3 + '.' + b4;
    }
}

