/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.graph;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.JoinDataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.graph.util.PageRankData;
import org.apache.flink.examples.scala.graph.PageRankBasic;
import org.apache.flink.examples.scala.graph.PageRankBasic$;
import org.apache.flink.examples.scala.graph.PageRankBasic$$anonfun$3$;
import org.apache.flink.util.Collector;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

public final class PageRankBasic$ {
    public static final PageRankBasic$ MODULE$;
    private final double org$apache$flink$examples$scala$graph$PageRankBasic$$DAMPENING_FACTOR;
    private final double org$apache$flink$examples$scala$graph$PageRankBasic$$EPSILON;

    static {
        new PageRankBasic$();
    }

    public final double org$apache$flink$examples$scala$graph$PageRankBasic$$DAMPENING_FACTOR() {
        return this.org$apache$flink$examples$scala$graph$PageRankBasic$$DAMPENING_FACTOR;
    }

    public final double org$apache$flink$examples$scala$graph$PageRankBasic$$EPSILON() {
        return this.org$apache$flink$examples$scala$graph$PageRankBasic$$EPSILON;
    }

    public void main(String[] args) {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        Predef$.MODULE$.println((Object)"Usage: PageRankBasic --pages <path> --links <path> --output <path> --numPages <n> --iterations <n>");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        Tuple2<DataSet<Object>, Object> tuple2 = this.getPagesDataSet(env, params);
        if (tuple2 != null) {
            DataSet finalRanks;
            Tuple2 tuple22;
            DataSet pages = (DataSet)tuple2._1();
            long numPages = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)pages, (Object)BoxesRunTime.boxToLong((long)numPages));
            DataSet pages2 = (DataSet)tuple23._1();
            long numPages2 = tuple23._2$mcJ$sp();
            DataSet<PageRankBasic.Link> links = this.getLinksDataSet(env, params);
            int maxIterations = params.getInt("iterations", 10);
            DataSet pagesWithRanks = pages2.map((Function1)new Serializable(numPages2){
                public static final long serialVersionUID = 0L;
                private final long numPages$1;

                public final PageRankBasic.Page apply(long p) {
                    return new PageRankBasic.Page(p, 1.0 / (double)this.numPages$1);
                }
                {
                    this.numPages$1 = numPages$1;
                }
            }, (TypeInformation)new CaseClassTypeInfo<PageRankBasic.Page>(){

                public TypeInformation<?>[] protected$types(anon.8 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<PageRankBasic.Page> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.8 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<PageRankBasic.Page>(this, fieldSerializers){

                        public PageRankBasic.Page createInstance(Object[] fields) {
                            return new PageRankBasic.Page(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(PageRankBasic.Page.class)).withForwardedFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*->pageId"}));
            DataSet adjacencyLists = links.groupBy("sourceId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).reduceGroup((GroupReduceFunction)new GroupReduceFunction<PageRankBasic.Link, PageRankBasic.AdjacencyList>(){

                public void reduce(java.lang.Iterable<PageRankBasic.Link> values, Collector<PageRankBasic.AdjacencyList> out) {
                    LongRef outputId = new LongRef(-1L);
                    Iterable outputList = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(values).asScala()).map((Function1)new Serializable(this, outputId){
                        public static final long serialVersionUID = 0L;
                        private final LongRef outputId$1;

                        public final long apply(PageRankBasic.Link t) {
                            this.outputId$1.elem = t.sourceId();
                            return t.targetId();
                        }
                        {
                            this.outputId$1 = outputId$1;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                    out.collect((Object)new PageRankBasic.AdjacencyList(outputId.elem, (long[])outputList.toArray(ClassTag$.MODULE$.Long())));
                }
            }, (TypeInformation)new CaseClassTypeInfo<PageRankBasic.AdjacencyList>(){

                public TypeInformation<?>[] protected$types(anon.9 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<PageRankBasic.AdjacencyList> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.9 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<PageRankBasic.AdjacencyList>(this, fieldSerializers){

                        public PageRankBasic.AdjacencyList createInstance(Object[] fields) {
                            return new PageRankBasic.AdjacencyList(BoxesRunTime.unboxToLong((Object)fields[0]), (long[])fields[1]);
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(PageRankBasic.AdjacencyList.class));
            DataSet result = finalRanks = pagesWithRanks.iterateWithTermination(maxIterations, (Function1)new Serializable(numPages2, adjacencyLists){
                public static final long serialVersionUID = 0L;
                public final long numPages$1;
                private final DataSet adjacencyLists$1;

                public final Tuple2<DataSet<PageRankBasic.Page>, DataSet<Object>> apply(DataSet<PageRankBasic.Page> currentRanks) {
                    DataSet newRanks = ((JoinDataSet)currentRanks.join(this.adjacencyLists$1).where("pageId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).equalTo("sourceId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).apply((Function3)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PageRankBasic.Page page, PageRankBasic.AdjacencyList adjacent, Collector<PageRankBasic.Page> out) {
                            long[] targets = adjacent.targetIds();
                            int len = targets.length;
                            Predef$.MODULE$.longArrayOps(adjacent.targetIds()).foreach((Function1)new Serializable(this, page, out, len){
                                public static final long serialVersionUID = 0L;
                                private final PageRankBasic.Page page$1;
                                private final Collector out$1;
                                private final int len$1;

                                public final void apply(long t) {
                                    this.apply$mcVJ$sp(t);
                                }

                                public void apply$mcVJ$sp(long t) {
                                    this.out$1.collect((Object)new PageRankBasic.Page(t, this.page$1.rank() / (double)this.len$1));
                                }
                                {
                                    this.page$1 = page$1;
                                    this.out$1 = out$1;
                                    this.len$1 = len$1;
                                }
                            });
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<PageRankBasic.Page>(this){

                        public TypeInformation<?>[] protected$types(anonfun$3$$anon$10 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<PageRankBasic.Page> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anon$10 $outer;
                                private final ExecutionConfig executionConfig$3;
                                private final TypeSerializer[] fieldSerializers$3;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$3 = executionConfig$3;
                                    this.fieldSerializers$3 = fieldSerializers$3;
                                }
                            });
                            return new CaseClassSerializer<PageRankBasic.Page>(this, fieldSerializers){

                                public PageRankBasic.Page createInstance(Object[] fields) {
                                    return new PageRankBasic.Page(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(PageRankBasic.Page.class)).groupBy("pageId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).aggregate(Aggregations.SUM, "rank").map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;

                        public final PageRankBasic.Page apply(PageRankBasic.Page p) {
                            return new PageRankBasic.Page(p.pageId(), p.rank() * PageRankBasic$.MODULE$.org$apache$flink$examples$scala$graph$PageRankBasic$$DAMPENING_FACTOR() + (1.0 - PageRankBasic$.MODULE$.org$apache$flink$examples$scala$graph$PageRankBasic$$DAMPENING_FACTOR()) / (double)this.$outer.numPages$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<PageRankBasic.Page>(this){

                        public TypeInformation<?>[] protected$types(anonfun$3$$anon$11 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<PageRankBasic.Page> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anon$11 $outer;
                                private final ExecutionConfig executionConfig$4;
                                private final TypeSerializer[] fieldSerializers$4;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$4 = executionConfig$4;
                                    this.fieldSerializers$4 = fieldSerializers$4;
                                }
                            });
                            return new CaseClassSerializer<PageRankBasic.Page>(this, fieldSerializers){

                                public PageRankBasic.Page createInstance(Object[] fields) {
                                    return new PageRankBasic.Page(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(PageRankBasic.Page.class)).withForwardedFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pageId"}));
                    DataSet termination = ((JoinDataSet)currentRanks.join(newRanks).where("pageId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).equalTo("pageId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).apply((Function3)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PageRankBasic.Page current, PageRankBasic.Page next, Collector<Object> out) {
                            if (package$.MODULE$.abs(current.rank() - next.rank()) > PageRankBasic$.MODULE$.org$apache$flink$examples$scala$graph$PageRankBasic$$EPSILON()) {
                                out.collect((Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }
                    }, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
                    return new Tuple2((Object)newRanks, (Object)termination);
                }
                {
                    this.numPages$1 = numPages$1;
                    this.adjacencyLists$1 = adjacencyLists$1;
                }
            });
            if (params.has("output")) {
                result.writeAsCsv(params.get("output"), "\n", " ", result.writeAsCsv$default$4());
                env.execute("Basic PageRank Example");
            } else {
                Predef$.MODULE$.println((Object)"Printing result to stdout. Use --output to specify output path.");
                result.print();
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<DataSet<Object>, Object> getPagesDataSet(ExecutionEnvironment env, ParameterTool params) {
        Tuple2 tuple2;
        if (params.has("pages") && params.has("numPages")) {
            String x$2 = params.get("pages");
            String x$3 = " ";
            String x$4 = "\n";
            Character x$5 = env.readCsvFile$default$4();
            boolean x$6 = env.readCsvFile$default$5();
            String x$7 = env.readCsvFile$default$6();
            boolean x$8 = env.readCsvFile$default$7();
            int[] x$9 = env.readCsvFile$default$8();
            String[] x$10 = env.readCsvFile$default$9();
            DataSet pages = env.readCsvFile(x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, ClassTag$.MODULE$.apply(Tuple1.class), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(){

                public TypeInformation<?>[] protected$types(anon.12 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.12 $outer;
                        private final ExecutionConfig executionConfig$5;
                        private final TypeSerializer[] fieldSerializers$5;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$5 = executionConfig$5;
                            this.fieldSerializers$5 = fieldSerializers$5;
                        }
                    });
                    return new CaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                        public Tuple1<Object> createInstance(Object[] fields) {
                            return new Tuple1.mcJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple1<Object> x) {
                    return x._1$mcJ$sp();
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
            tuple2 = new Tuple2((Object)pages, (Object)BoxesRunTime.boxToLong((long)params.getLong("numPages")));
        } else {
            Predef$.MODULE$.println((Object)"Executing PageRank example with default pages data set.");
            Predef$.MODULE$.println((Object)"Use --pages and --numPages to specify file input.");
            tuple2 = new Tuple2((Object)env.generateSequence(1L, 15L), (Object)BoxesRunTime.boxToLong((long)PageRankData.getNumberOfPages()));
        }
        return tuple2;
    }

    private DataSet<PageRankBasic.Link> getLinksDataSet(ExecutionEnvironment env, ParameterTool params) {
        DataSet dataSet;
        if (params.has("links")) {
            String x$11 = params.get("links");
            String x$12 = " ";
            int[] x$13 = new int[]{0, 1};
            String x$14 = env.readCsvFile$default$2();
            Character x$15 = env.readCsvFile$default$4();
            boolean x$16 = env.readCsvFile$default$5();
            String x$17 = env.readCsvFile$default$6();
            boolean x$18 = env.readCsvFile$default$7();
            String[] x$19 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$11, x$14, x$12, x$15, x$16, x$17, x$18, x$13, x$19, ClassTag$.MODULE$.apply(PageRankBasic.Link.class), (TypeInformation)new CaseClassTypeInfo<PageRankBasic.Link>(){

                public TypeInformation<?>[] protected$types(anon.13 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<PageRankBasic.Link> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.13 $outer;
                        private final ExecutionConfig executionConfig$6;
                        private final TypeSerializer[] fieldSerializers$6;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$6 = executionConfig$6;
                            this.fieldSerializers$6 = fieldSerializers$6;
                        }
                    });
                    return new CaseClassSerializer<PageRankBasic.Link>(this, fieldSerializers){

                        public PageRankBasic.Link createInstance(Object[] fields) {
                            return new PageRankBasic.Link(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            });
        } else {
            Predef$.MODULE$.println((Object)"Executing PageRank example with default links data set.");
            Predef$.MODULE$.println((Object)"Use --links to specify file input.");
            PageRankBasic.Link[] edges = (PageRankBasic.Link[])Predef$.MODULE$.refArrayOps((Object[])PageRankData.EDGES).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final PageRankBasic.Link apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object v1 = ((SeqLike)option.get()).apply(0);
                        Object v2 = ((SeqLike)option.get()).apply(1);
                        PageRankBasic.Link link = new PageRankBasic.Link(BoxesRunTime.unboxToLong((Object)v1), BoxesRunTime.unboxToLong((Object)v2));
                        return link;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PageRankBasic.Link.class)));
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])edges), ClassTag$.MODULE$.apply(PageRankBasic.Link.class), (TypeInformation)new CaseClassTypeInfo<PageRankBasic.Link>(){

                public TypeInformation<?>[] protected$types(anon.14 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<PageRankBasic.Link> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.14 $outer;
                        private final ExecutionConfig executionConfig$7;
                        private final TypeSerializer[] fieldSerializers$7;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$7 = executionConfig$7;
                            this.fieldSerializers$7 = fieldSerializers$7;
                        }
                    });
                    return new CaseClassSerializer<PageRankBasic.Link>(this, fieldSerializers){

                        public PageRankBasic.Link createInstance(Object[] fields) {
                            return new PageRankBasic.Link(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private PageRankBasic$() {
        MODULE$ = this;
        this.org$apache$flink$examples$scala$graph$PageRankBasic$$DAMPENING_FACTOR = 0.85;
        this.org$apache$flink$examples$scala$graph$PageRankBasic$$EPSILON = 1.0E-4;
    }
}

