/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.clustering;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.clustering.util.KMeansData;
import org.apache.flink.examples.scala.clustering.KMeans;
import org.apache.flink.examples.scala.clustering.KMeans$;
import org.apache.flink.examples.scala.clustering.KMeans$$anonfun$1$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class KMeans$ {
    public static final KMeans$ MODULE$;

    static {
        new KMeans$();
    }

    public void main(String[] args) {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        Predef$.MODULE$.println((Object)"Usage: KMeans --points <path> --centroids <path> --output <path> --iterations <n>");
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<KMeans.Point> points = this.getPointDataSet(params, env);
        DataSet<KMeans.Centroid> centroids = this.getCentroidDataSet(params, env);
        DataSet finalCentroids = centroids.iterate(params.getInt("iterations", 10), (Function1)new Serializable(points){
            public static final long serialVersionUID = 0L;
            private final DataSet points$1;

            /*
             * WARNING - void declaration
             */
            public final DataSet<KMeans.Centroid> apply(DataSet<KMeans.Centroid> currentCentroids) {
                void var2_2;
                DataSet newCentroids = this.points$1.map((MapFunction)new KMeans.SelectNearestCenter(), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, KMeans.Point>>(this){

                    public TypeInformation<?>[] protected$types(anonfun$1$$anon$15 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<Tuple2<Object, KMeans.Point>> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$1$$anon$15 $outer;
                            private final ExecutionConfig executionConfig$1;
                            private final TypeSerializer[] fieldSerializers$3;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.executionConfig$1 = executionConfig$1;
                                this.fieldSerializers$3 = fieldSerializers$3;
                            }
                        });
                        return new CaseClassSerializer<Tuple2<Object, KMeans.Point>>(this, fieldSerializers){

                            public Tuple2<Object, KMeans.Point> createInstance(Object[] fields) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((KMeans.Point)fields[1]));
                            }
                        };
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).withBroadcastSet(currentCentroids, "centroids").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, KMeans.Point, Object> apply(Tuple2<Object, KMeans.Point> x) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), x._2(), (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, KMeans.Point, Object>>(this){

                    public TypeInformation<?>[] protected$types(anonfun$1$$anon$18 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<Tuple3<Object, KMeans.Point, Object>> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$1$$anon$18 $outer;
                            private final ExecutionConfig executionConfig$4;
                            private final TypeSerializer[] fieldSerializers$6;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.executionConfig$4 = executionConfig$4;
                                this.fieldSerializers$6 = fieldSerializers$6;
                            }
                        });
                        return new CaseClassSerializer<Tuple3<Object, KMeans.Point, Object>>(this, fieldSerializers){

                            public Tuple3<Object, KMeans.Point, Object> createInstance(Object[] fields) {
                                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((KMeans.Point)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                            }
                        };
                    }
                }, ClassTag$.MODULE$.apply(Tuple3.class)).withForwardedFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1; _2"})).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, KMeans.Point, Object> apply(Tuple3<Object, KMeans.Point, Object> p1, Tuple3<Object, KMeans.Point, Object> p2) {
                        return new Tuple3(p1._1(), (Object)((KMeans.Coordinate)p1._2()).add((KMeans.Coordinate)p2._2()), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)p1._3()) + BoxesRunTime.unboxToLong((Object)p2._3()))));
                    }
                }).withForwardedFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1"})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final KMeans.Centroid apply(Tuple3<Object, KMeans.Point, Object> x) {
                        return new KMeans.Centroid(BoxesRunTime.unboxToInt((Object)x._1()), (KMeans.Point)((KMeans.Coordinate)x._2()).div(BoxesRunTime.unboxToLong((Object)x._3())));
                    }
                }, (TypeInformation)new CaseClassTypeInfo<KMeans.Centroid>(this){

                    public TypeInformation<?>[] protected$types(anonfun$1$$anon$21 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<KMeans.Centroid> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$1$$anon$21 $outer;
                            private final ExecutionConfig executionConfig$7;
                            private final TypeSerializer[] fieldSerializers$7;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.executionConfig$7 = executionConfig$7;
                                this.fieldSerializers$7 = fieldSerializers$7;
                            }
                        });
                        return new CaseClassSerializer<KMeans.Centroid>(this, fieldSerializers){

                            public KMeans.Centroid createInstance(Object[] fields) {
                                return new KMeans.Centroid(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]));
                            }
                        };
                    }
                }, ClassTag$.MODULE$.apply(KMeans.Centroid.class)).withForwardedFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1->id"}));
                return var2_2;
            }
            {
                this.points$1 = points$1;
            }
        });
        DataSet clusteredPoints = points.map((MapFunction)new KMeans.SelectNearestCenter(), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, KMeans.Point>>(){

            public TypeInformation<?>[] protected$types(anon.22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, KMeans.Point>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.22 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$10;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$10[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$10 = fieldSerializers$10;
                    }
                });
                return new CaseClassSerializer<Tuple2<Object, KMeans.Point>>(this, fieldSerializers){

                    public Tuple2<Object, KMeans.Point> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((KMeans.Point)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).withBroadcastSet(finalCentroids, "centroids");
        if (params.has("output")) {
            clusteredPoints.writeAsCsv(params.get("output"), "\n", " ", clusteredPoints.writeAsCsv$default$4());
            env.execute("Scala KMeans Example");
        } else {
            Predef$.MODULE$.println((Object)"Printing result to stdout. Use --output to specify output path.");
            clusteredPoints.print();
        }
    }

    public DataSet<KMeans.Centroid> getCentroidDataSet(ParameterTool params, ExecutionEnvironment env) {
        DataSet dataSet;
        if (params.has("centroids")) {
            String x$1 = params.get("centroids");
            String x$2 = " ";
            int[] x$3 = new int[]{0, 1, 2};
            String x$4 = env.readCsvFile$default$2();
            Character x$5 = env.readCsvFile$default$4();
            boolean x$6 = env.readCsvFile$default$5();
            String x$7 = env.readCsvFile$default$6();
            boolean x$8 = env.readCsvFile$default$7();
            String[] x$9 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$1, x$4, x$2, x$5, x$6, x$7, x$8, x$3, x$9, ClassTag$.MODULE$.apply(KMeans.Centroid.class), (TypeInformation)new CaseClassTypeInfo<KMeans.Centroid>(){

                public TypeInformation<?>[] protected$types(anon.25 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<KMeans.Centroid> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.25 $outer;
                        private final ExecutionConfig executionConfig$11;
                        private final TypeSerializer[] fieldSerializers$11;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$11[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$11);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$11 = executionConfig$11;
                            this.fieldSerializers$11 = fieldSerializers$11;
                        }
                    });
                    return new CaseClassSerializer<KMeans.Centroid>(this, fieldSerializers){

                        public KMeans.Centroid createInstance(Object[] fields) {
                            return new KMeans.Centroid(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]));
                        }
                    };
                }
            });
        } else {
            Predef$.MODULE$.println((Object)"Executing K-Means example with default centroid data set.");
            Predef$.MODULE$.println((Object)"Use --centroids to specify file input.");
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])KMeansData.CENTROIDS).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final KMeans.Centroid apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                        Object id = ((SeqLike)option.get()).apply(0);
                        Object x = ((SeqLike)option.get()).apply(1);
                        Object y = ((SeqLike)option.get()).apply(2);
                        KMeans.Centroid centroid = new KMeans.Centroid(BoxesRunTime.unboxToInt((Object)id), BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y));
                        return centroid;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KMeans.Centroid.class)))), ClassTag$.MODULE$.apply(KMeans.Centroid.class), (TypeInformation)new CaseClassTypeInfo<KMeans.Centroid>(){

                public TypeInformation<?>[] protected$types(anon.26 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<KMeans.Centroid> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.26 $outer;
                        private final ExecutionConfig executionConfig$12;
                        private final TypeSerializer[] fieldSerializers$12;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$12[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$12);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$12 = executionConfig$12;
                            this.fieldSerializers$12 = fieldSerializers$12;
                        }
                    });
                    return new CaseClassSerializer<KMeans.Centroid>(this, fieldSerializers){

                        public KMeans.Centroid createInstance(Object[] fields) {
                            return new KMeans.Centroid(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    public DataSet<KMeans.Point> getPointDataSet(ParameterTool params, ExecutionEnvironment env) {
        DataSet dataSet;
        if (params.has("points")) {
            String x$10 = params.get("points");
            String x$11 = " ";
            int[] x$12 = new int[]{0, 1};
            String x$13 = env.readCsvFile$default$2();
            Character x$14 = env.readCsvFile$default$4();
            boolean x$15 = env.readCsvFile$default$5();
            String x$16 = env.readCsvFile$default$6();
            boolean x$17 = env.readCsvFile$default$7();
            String[] x$18 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$10, x$13, x$11, x$14, x$15, x$16, x$17, x$12, x$18, ClassTag$.MODULE$.apply(KMeans.Point.class), (TypeInformation)new CaseClassTypeInfo<KMeans.Point>(){

                public TypeInformation<?>[] protected$types(anon.27 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<KMeans.Point> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.27 $outer;
                        private final ExecutionConfig executionConfig$13;
                        private final TypeSerializer[] fieldSerializers$13;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$13[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$13);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$13 = executionConfig$13;
                            this.fieldSerializers$13 = fieldSerializers$13;
                        }
                    });
                    return new CaseClassSerializer<KMeans.Point>(this, fieldSerializers){

                        public KMeans.Point createInstance(Object[] fields) {
                            return new KMeans.Point(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                        }
                    };
                }
            });
        } else {
            Predef$.MODULE$.println((Object)"Executing K-Means example with default points data set.");
            Predef$.MODULE$.println((Object)"Use --points to specify file input.");
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])KMeansData.POINTS).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final KMeans.Point apply(Object[] x0$2) {
                    Object[] objectArray = x0$2;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        KMeans.Point point = new KMeans.Point(BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y));
                        return point;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KMeans.Point.class)))), ClassTag$.MODULE$.apply(KMeans.Point.class), (TypeInformation)new CaseClassTypeInfo<KMeans.Point>(){

                public TypeInformation<?>[] protected$types(anon.28 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<KMeans.Point> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.28 $outer;
                        private final ExecutionConfig executionConfig$14;
                        private final TypeSerializer[] fieldSerializers$14;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$14[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$14);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$14 = executionConfig$14;
                            this.fieldSerializers$14 = fieldSerializers$14;
                        }
                    });
                    return new CaseClassSerializer<KMeans.Point>(this, fieldSerializers){

                        public KMeans.Point createInstance(Object[] fields) {
                            return new KMeans.Point(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private KMeans$() {
        MODULE$ = this;
    }
}

