/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPCHQuery10 {
    private static final Logger LOGGER = LoggerFactory.getLogger(TPCHQuery10.class);

    public static void main(String[] args) throws Exception {
        LOGGER.warn("All Flink DataSet APIs are deprecated since Flink 1.18 and will be removed in a future Flink major version. You can still build your application in DataSet, but you should move to either the DataStream and/or Table API. This class is retained for testing purposes. See Also: https://cwiki.apache.org/confluence/pages/viewpage.action?pageId=158866741");
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (!(params.has("customer") || params.has("orders") || params.has("lineitem") || params.has("nation"))) {
            System.err.println("  This program expects data from the TPC-H benchmark as input data.");
            System.err.println("  Due to legal restrictions, we can not ship generated data.");
            System.err.println("  You can find the TPC-H data generator at http://www.tpc.org/tpch/.");
            System.err.println("  Usage: TPCHQuery10 --customer <path> --orders <path> --lineitem <path> --nation <path> [--output <path>]");
            return;
        }
        DataSet<Tuple5<Integer, String, String, Integer, Double>> customers = TPCHQuery10.getCustomerDataSet(env, params.get("customer"));
        DataSet<Tuple3<Integer, Integer, String>> orders = TPCHQuery10.getOrdersDataSet(env, params.get("orders"));
        DataSet<Tuple4<Integer, Double, Double, String>> lineitems = TPCHQuery10.getLineitemDataSet(env, params.get("lineitem"));
        DataSet<Tuple2<Integer, String>> nations = TPCHQuery10.getNationsDataSet(env, params.get("nation"));
        ProjectOperator ordersFilteredByYear = orders.filter((FilterFunction & Serializable)order -> Integer.parseInt(((String)order.f2).substring(0, 4)) > 1990).project(new int[]{0, 1});
        SingleInputUdfOperator lineitemsFilteredByFlag = lineitems.filter((FilterFunction & Serializable)lineitem -> ((String)lineitem.f3).equals("R")).map((MapFunction & Serializable)lineitem -> new Tuple2(lineitem.f0, (Object)((Double)lineitem.f1 * (1.0 - (Double)lineitem.f2)))).returns(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT, Types.DOUBLE}));
        JoinOperator.ProjectJoin revenueByCustomer = ordersFilteredByYear.joinWithHuge((DataSet)lineitemsFilteredByFlag).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{1}).projectSecond(new int[]{1});
        revenueByCustomer = revenueByCustomer.groupBy(new int[]{0}).aggregate(Aggregations.SUM, 1);
        JoinOperator.ProjectJoin customerWithNation = customers.joinWithTiny(nations).where(new int[]{3}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1, 2}).projectSecond(new int[]{1}).projectFirst(new int[]{4});
        JoinOperator.ProjectJoin result = customerWithNation.join((DataSet)revenueByCustomer).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1, 2, 3, 4}).projectSecond(new int[]{1});
        if (params.has("output")) {
            result.writeAsCsv(params.get("output"), "\n", "|");
            env.execute("TPCH Query 10 Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            result.print();
        }
    }

    private static DataSet<Tuple5<Integer, String, String, Integer, Double>> getCustomerDataSet(ExecutionEnvironment env, String customerPath) {
        return env.readCsvFile(customerPath).fieldDelimiter("|").includeFields("11110100").types(Integer.class, String.class, String.class, Integer.class, Double.class);
    }

    private static DataSet<Tuple3<Integer, Integer, String>> getOrdersDataSet(ExecutionEnvironment env, String ordersPath) {
        return env.readCsvFile(ordersPath).fieldDelimiter("|").includeFields("110010000").types(Integer.class, Integer.class, String.class);
    }

    private static DataSet<Tuple4<Integer, Double, Double, String>> getLineitemDataSet(ExecutionEnvironment env, String lineitemPath) {
        return env.readCsvFile(lineitemPath).fieldDelimiter("|").includeFields("1000011010000000").types(Integer.class, Double.class, Double.class, String.class);
    }

    private static DataSet<Tuple2<Integer, String>> getNationsDataSet(ExecutionEnvironment env, String nationPath) {
        return env.readCsvFile(nationPath).fieldDelimiter("|").includeFields("1100").types(Integer.class, String.class);
    }
}

