/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.clustering.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Random;
import org.apache.flink.api.java.utils.ParameterTool;

public class KMeansDataGenerator {
    private static final String CENTERS_FILE = "centers";
    private static final String POINTS_FILE = "points";
    private static final long DEFAULT_SEED = 4650285087650871364L;
    private static final double DEFAULT_VALUE_RANGE = 100.0;
    private static final double RELATIVE_STDDEV = 0.08;
    private static final int DIMENSIONALITY = 2;
    private static final DecimalFormat FORMAT;
    private static final char DELIMITER = ' ';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int i;
        if (args.length < 2) {
            System.out.println("KMeansDataGenerator -points <num> -k <num clusters> [-output <output-path>] [-stddev <relative stddev>] [-range <centroid range>] [-seed <seed>]");
            System.exit(1);
        }
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        int numDataPoints = params.getInt(POINTS_FILE);
        int k = params.getInt("k");
        String outDir = params.get("output", System.getProperty("java.io.tmpdir"));
        double stddev = params.getDouble("stddev", 0.08);
        double range = params.getDouble("range", 100.0);
        long firstSeed = params.getLong("seed", 4650285087650871364L);
        double absoluteStdDev = stddev * range;
        Random random = new Random(firstSeed);
        double[][] means = KMeansDataGenerator.uniformRandomCenters(random, k, 2, range);
        try (BufferedWriter pointsOut = null;){
            pointsOut = new BufferedWriter(new FileWriter(new File(outDir + "/" + POINTS_FILE)));
            StringBuilder buffer = new StringBuilder();
            double[] point = new double[2];
            int nextCentroid = 0;
            for (i = 1; i <= numDataPoints; ++i) {
                double[] centroid = means[nextCentroid];
                for (int d = 0; d < 2; ++d) {
                    point[d] = random.nextGaussian() * absoluteStdDev + centroid[d];
                }
                KMeansDataGenerator.writePoint(point, buffer, pointsOut);
                nextCentroid = (nextCentroid + 1) % k;
            }
        }
        try (BufferedWriter centersOut = null;){
            centersOut = new BufferedWriter(new FileWriter(new File(outDir + "/" + CENTERS_FILE)));
            StringBuilder buffer = new StringBuilder();
            double[][] centers = KMeansDataGenerator.uniformRandomCenters(random, k, 2, range);
            for (i = 0; i < k; ++i) {
                KMeansDataGenerator.writeCenter(i + 1, centers[i], buffer, centersOut);
            }
        }
        System.out.println("Wrote " + numDataPoints + " data points to " + outDir + "/" + POINTS_FILE);
        System.out.println("Wrote " + k + " cluster centers to " + outDir + "/" + CENTERS_FILE);
    }

    private static double[][] uniformRandomCenters(Random rnd, int num, int dimensionality, double range) {
        double halfRange = range / 2.0;
        double[][] points = new double[num][dimensionality];
        for (int i = 0; i < num; ++i) {
            for (int dim = 0; dim < dimensionality; ++dim) {
                points[i][dim] = rnd.nextDouble() * range - halfRange;
            }
        }
        return points;
    }

    private static void writePoint(double[] coordinates, StringBuilder buffer, BufferedWriter out) throws IOException {
        buffer.setLength(0);
        for (int j = 0; j < coordinates.length; ++j) {
            buffer.append(FORMAT.format(coordinates[j]));
            if (j >= coordinates.length - 1) continue;
            buffer.append(' ');
        }
        out.write(buffer.toString());
        out.newLine();
    }

    private static void writeCenter(long id, double[] coordinates, StringBuilder buffer, BufferedWriter out) throws IOException {
        buffer.setLength(0);
        buffer.append(id);
        buffer.append(' ');
        for (int j = 0; j < coordinates.length; ++j) {
            buffer.append(FORMAT.format(coordinates[j]));
            if (j >= coordinates.length - 1) continue;
            buffer.append(' ');
        }
        out.write(buffer.toString());
        out.newLine();
    }

    static {
        Locale.setDefault(Locale.US);
        FORMAT = new DecimalFormat("#0.00");
    }
}

