/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPCHQuery3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(TPCHQuery3.class);

    public static void main(String[] args) throws Exception {
        LOGGER.warn("All Flink DataSet APIs are deprecated since Flink 1.18 and will be removed in a future Flink major version. You can still build your application in DataSet, but you should move to either the DataStream and/or Table API. This class is retained for testing purposes. See Also: https://cwiki.apache.org/confluence/pages/viewpage.action?pageId=158866741");
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        if (!(params.has("lineitem") || params.has("customer") || params.has("orders"))) {
            System.err.println("  This program expects data from the TPC-H benchmark as input data.");
            System.err.println("  Due to legal restrictions, we can not ship generated data.");
            System.out.println("  You can find the TPC-H data generator at http://www.tpc.org/tpch/.");
            System.out.println("  Usage: TPCHQuery3 --lineitem <path> --customer <path> --orders <path> [--output <path>]");
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        FilterOperator lineitems = TPCHQuery3.getLineitemDataSet(env, params.get("lineitem"));
        FilterOperator customers = TPCHQuery3.getCustomerDataSet(env, params.get("customer"));
        FilterOperator orders = TPCHQuery3.getOrdersDataSet(env, params.get("orders"));
        customers = customers.filter((FilterFunction)new FilterFunction<Customer>(){

            public boolean filter(Customer c) {
                return c.getMktsegment().equals("AUTOMOBILE");
            }
        });
        orders = orders.filter((FilterFunction)new FilterFunction<Order>(){
            private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            private final Date date = this.format.parse("1995-03-12");

            public boolean filter(Order o) throws ParseException {
                return this.format.parse(o.getOrderdate()).before(this.date);
            }
        });
        lineitems = lineitems.filter((FilterFunction)new FilterFunction<Lineitem>(){
            private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            private final Date date = this.format.parse("1995-03-12");

            public boolean filter(Lineitem l) throws ParseException {
                return this.format.parse(l.getShipdate()).after(this.date);
            }
        });
        JoinOperator.EquiJoin customerWithOrders = customers.join((DataSet)orders).where(new int[]{0}).equalTo(new int[]{1}).with((JoinFunction)new JoinFunction<Customer, Order, ShippingPriorityItem>(){

            public ShippingPriorityItem join(Customer c, Order o) {
                return new ShippingPriorityItem(o.getOrderKey(), 0.0, o.getOrderdate(), o.getShippriority());
            }
        });
        AggregateOperator result = customerWithOrders.join((DataSet)lineitems).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<ShippingPriorityItem, Lineitem, ShippingPriorityItem>(){

            public ShippingPriorityItem join(ShippingPriorityItem i, Lineitem l) {
                i.setRevenue(l.getExtendedprice() * (1.0 - l.getDiscount()));
                return i;
            }
        }).groupBy(new int[]{0, 2, 3}).aggregate(Aggregations.SUM, 1);
        if (params.has("output")) {
            result.writeAsCsv(params.get("output"), "\n", "|");
            env.execute("TPCH Query 3 Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            result.print();
        }
    }

    private static DataSet<Lineitem> getLineitemDataSet(ExecutionEnvironment env, String lineitemPath) {
        return env.readCsvFile(lineitemPath).fieldDelimiter("|").includeFields("1000011000100000").tupleType(Lineitem.class);
    }

    private static DataSet<Customer> getCustomerDataSet(ExecutionEnvironment env, String customerPath) {
        return env.readCsvFile(customerPath).fieldDelimiter("|").includeFields("10000010").tupleType(Customer.class);
    }

    private static DataSet<Order> getOrdersDataSet(ExecutionEnvironment env, String ordersPath) {
        return env.readCsvFile(ordersPath).fieldDelimiter("|").includeFields("110010010").tupleType(Order.class);
    }

    public static class ShippingPriorityItem
    extends Tuple4<Long, Double, String, Long> {
        public ShippingPriorityItem() {
        }

        public ShippingPriorityItem(Long orderkey, Double revenue, String orderdate, Long shippriority) {
            this.f0 = orderkey;
            this.f1 = revenue;
            this.f2 = orderdate;
            this.f3 = shippriority;
        }

        public Long getOrderkey() {
            return (Long)this.f0;
        }

        public void setOrderkey(Long orderkey) {
            this.f0 = orderkey;
        }

        public Double getRevenue() {
            return (Double)this.f1;
        }

        public void setRevenue(Double revenue) {
            this.f1 = revenue;
        }

        public String getOrderdate() {
            return (String)this.f2;
        }

        public Long getShippriority() {
            return (Long)this.f3;
        }
    }

    public static class Order
    extends Tuple4<Long, Long, String, Long> {
        public Long getOrderKey() {
            return (Long)this.f0;
        }

        public Long getCustKey() {
            return (Long)this.f1;
        }

        public String getOrderdate() {
            return (String)this.f2;
        }

        public Long getShippriority() {
            return (Long)this.f3;
        }
    }

    public static class Customer
    extends Tuple2<Long, String> {
        public Long getCustKey() {
            return (Long)this.f0;
        }

        public String getMktsegment() {
            return (String)this.f1;
        }
    }

    public static class Lineitem
    extends Tuple4<Long, Double, Double, String> {
        public Long getOrderkey() {
            return (Long)this.f0;
        }

        public Double getDiscount() {
            return (Double)this.f2;
        }

        public Double getExtendedprice() {
            return (Double)this.f1;
        }

        public String getShipdate() {
            return (String)this.f3;
        }
    }
}

