/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.changelog.fs.StateChangeSet;
import org.apache.flink.changelog.fs.StateChangeUploadScheduler;
import org.apache.flink.changelog.fs.UploadResult;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

interface StateChangeUploader
extends AutoCloseable {
    public UploadTasksResult upload(Collection<StateChangeUploadScheduler.UploadTask> var1) throws IOException;

    public static final class UploadTasksResult {
        private final Map<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Long>> tasksOffsets;
        private final StreamStateHandle handle;

        public UploadTasksResult(Map<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Long>> tasksOffsets, StreamStateHandle handle) {
            this.tasksOffsets = Collections.unmodifiableMap(tasksOffsets);
            this.handle = (StreamStateHandle)Preconditions.checkNotNull((Object)handle);
        }

        public void complete() {
            for (Map.Entry<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Long>> entry : this.tasksOffsets.entrySet()) {
                StateChangeUploadScheduler.UploadTask task = entry.getKey();
                Map<StateChangeSet, Long> offsets = entry.getValue();
                task.complete(this.buildResults(this.handle, offsets));
            }
        }

        private List<UploadResult> buildResults(StreamStateHandle handle, Map<StateChangeSet, Long> offsets) {
            return offsets.entrySet().stream().map(e -> UploadResult.of(handle, (StateChangeSet)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
        }

        public long getStateSize() {
            return this.handle.getStateSize();
        }

        public void discard() throws Exception {
            this.handle.discardState();
        }
    }
}

