/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.io.OutputStream;

class OutputStreamWithPos
extends OutputStream {
    private final OutputStream outputStream;
    private long pos;

    public OutputStreamWithPos(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        ++this.pos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.pos += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.pos += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public long getPos() {
        return this.pos;
    }
}

