/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.changelog.fs.ChangelogStorageMetricGroup;
import org.apache.flink.changelog.fs.FsStateChangelogOptions;
import org.apache.flink.changelog.fs.FsStateChangelogWriter;
import org.apache.flink.changelog.fs.StateChangeFormat;
import org.apache.flink.changelog.fs.StateChangeFsUploader;
import org.apache.flink.changelog.fs.StateChangeUploadScheduler;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandleStreamImpl;
import org.apache.flink.runtime.state.changelog.StateChangelogHandleReader;
import org.apache.flink.runtime.state.changelog.StateChangelogHandleStreamHandleReader;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class FsStateChangelogStorage
implements StateChangelogStorage<ChangelogStateHandleStreamImpl> {
    private static final Logger LOG = LoggerFactory.getLogger(FsStateChangelogStorage.class);
    private final StateChangeUploadScheduler uploader;
    private final long preEmptivePersistThresholdInBytes;
    private final AtomicInteger logIdGenerator = new AtomicInteger(0);

    public FsStateChangelogStorage(Configuration config, TaskManagerJobMetricGroup metricGroup) throws IOException {
        this(StateChangeUploadScheduler.fromConfig((ReadableConfig)config, new ChangelogStorageMetricGroup((MetricGroup)metricGroup)), ((MemorySize)config.get(FsStateChangelogOptions.PREEMPTIVE_PERSIST_THRESHOLD)).getBytes());
    }

    @VisibleForTesting
    public FsStateChangelogStorage(Path basePath, boolean compression, int bufferSize, ChangelogStorageMetricGroup metricGroup) throws IOException {
        this(StateChangeUploadScheduler.directScheduler(new StateChangeFsUploader(basePath, basePath.getFileSystem(), compression, bufferSize, metricGroup)), ((MemorySize)FsStateChangelogOptions.PREEMPTIVE_PERSIST_THRESHOLD.defaultValue()).getBytes());
    }

    @VisibleForTesting
    public FsStateChangelogStorage(StateChangeUploadScheduler uploader, long preEmptivePersistThresholdInBytes) {
        this.uploader = uploader;
        this.preEmptivePersistThresholdInBytes = preEmptivePersistThresholdInBytes;
    }

    public FsStateChangelogWriter createWriter(String operatorID, KeyGroupRange keyGroupRange, MailboxExecutor mailboxExecutor) {
        UUID logId = new UUID(0L, this.logIdGenerator.getAndIncrement());
        LOG.info("createWriter for operator {}/{}: {}", new Object[]{operatorID, keyGroupRange, logId});
        return new FsStateChangelogWriter(logId, keyGroupRange, this.uploader, this.preEmptivePersistThresholdInBytes, mailboxExecutor);
    }

    public StateChangelogHandleReader<ChangelogStateHandleStreamImpl> createReader() {
        return new StateChangelogHandleStreamHandleReader((StateChangelogHandleStreamHandleReader.StateChangeIterator)new StateChangeFormat());
    }

    public void close() throws Exception {
        this.uploader.close();
    }

    public AvailabilityProvider getAvailabilityProvider() {
        return this.uploader.getAvailabilityProvider();
    }
}

