/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.utils;

import java.util.Set;
import org.apache.flink.api.common.state.IllegalRedistributionModeException;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.dsv2.Sink;
import org.apache.flink.api.connector.dsv2.WrappedSink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.api.stream.GlobalStream;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.datastream.impl.stream.GlobalStreamImpl;
import org.apache.flink.datastream.impl.stream.KeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.NonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndGlobalStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndNonKeyedPartitionStreamImpl;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleUdfStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.DataStreamV2SinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.util.Utils;

public final class StreamUtils {
    public static <IN, OUT> TypeInformation<OUT> getOutputTypeForOneInputProcessFunction(OneInputStreamProcessFunction<IN, OUT> processFunction, TypeInformation<IN> inTypeInformation) {
        return TypeExtractor.getUnaryOperatorReturnType(processFunction, OneInputStreamProcessFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, inTypeInformation, (String)Utils.getCallLocationName(), (boolean)true);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getOutputTypeForTwoInputNonBroadcastProcessFunction(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> processFunction, TypeInformation<IN1> in1TypeInformation, TypeInformation<IN2> in2TypeInformation) {
        return TypeExtractor.getBinaryOperatorReturnType(processFunction, TwoInputNonBroadcastStreamProcessFunction.class, (int)0, (int)1, (int)2, (int[])TypeExtractor.NO_INDEX, in1TypeInformation, in2TypeInformation, (String)Utils.getCallLocationName(), (boolean)true);
    }

    public static <IN1, IN2, OUT> TypeInformation<OUT> getOutputTypeForTwoInputBroadcastProcessFunction(TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> processFunction, TypeInformation<IN1> in1TypeInformation, TypeInformation<IN2> in2TypeInformation) {
        return TypeExtractor.getBinaryOperatorReturnType(processFunction, TwoInputBroadcastStreamProcessFunction.class, (int)0, (int)1, (int)2, (int[])TypeExtractor.NO_INDEX, in1TypeInformation, in2TypeInformation, (String)Utils.getCallLocationName(), (boolean)true);
    }

    public static <IN, OUT1, OUT2> Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> getOutputTypesForTwoOutputProcessFunction(TwoOutputStreamProcessFunction<IN, OUT1, OUT2> twoOutputStreamProcessFunction, TypeInformation<IN> inTypeInformation) {
        TypeInformation firstOutputType = TypeExtractor.getUnaryOperatorReturnType(twoOutputStreamProcessFunction, TwoOutputStreamProcessFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, inTypeInformation, (String)Utils.getCallLocationName(), (boolean)true);
        TypeInformation secondOutputType = TypeExtractor.getUnaryOperatorReturnType(twoOutputStreamProcessFunction, TwoOutputStreamProcessFunction.class, (int)0, (int)2, (int[])new int[]{2, 0}, inTypeInformation, (String)Utils.getCallLocationName(), (boolean)true);
        return Tuple2.of((Object)firstOutputType, (Object)secondOutputType);
    }

    public static <T, R> OneInputTransformation<T, R> getOneInputTransformation(String operatorName, AbstractDataStream<T> inputStream, TypeInformation<R> outTypeInformation, OneInputStreamOperator<T, R> operator) {
        inputStream.getTransformation().getOutputType();
        OneInputTransformation resultTransform = new OneInputTransformation(inputStream.getTransformation(), operatorName, (StreamOperatorFactory)SimpleUdfStreamOperatorFactory.of(operator), outTypeInformation, inputStream.getEnvironment().getParallelism(), false);
        return resultTransform;
    }

    public static <T, R, K> OneInputTransformation<T, R> getOneInputKeyedTransformation(String operatorName, AbstractDataStream<T> inputStream, TypeInformation<R> outTypeInformation, OneInputStreamOperator<T, R> operator, KeySelector<T, K> keySelector, TypeInformation<K> keyType) {
        OneInputTransformation<T, R> resultTransform = StreamUtils.getOneInputTransformation(operatorName, inputStream, outTypeInformation, operator);
        resultTransform.setStateKeySelector(keySelector);
        resultTransform.setStateKeyType(keyType);
        return resultTransform;
    }

    public static <IN1, IN2, OUT> TwoInputTransformation<IN1, IN2, OUT> getTwoInputTransformation(String operatorName, AbstractDataStream<IN1> inputStream1, AbstractDataStream<IN2> inputStream2, TypeInformation<OUT> outTypeInformation, TwoInputStreamOperator<IN1, IN2, OUT> operator) {
        TwoInputTransformation transform = new TwoInputTransformation(inputStream1.getTransformation(), inputStream2.getTransformation(), operatorName, (StreamOperatorFactory)SimpleOperatorFactory.of(operator), outTypeInformation, inputStream1.getEnvironment().getParallelism(), false);
        TypeInformation keyType = null;
        if (inputStream1 instanceof KeyedPartitionStreamImpl) {
            KeyedPartitionStreamImpl keyedInput1 = (KeyedPartitionStreamImpl)inputStream1;
            keyType = keyedInput1.getKeyType();
            transform.setStateKeySelectors(keyedInput1.getKeySelector(), null);
            transform.setStateKeyType(keyType);
        }
        if (inputStream2 instanceof KeyedPartitionStreamImpl) {
            KeyedPartitionStreamImpl keyedInput2 = (KeyedPartitionStreamImpl)inputStream2;
            TypeInformation keyType2 = keyedInput2.getKeyType();
            if (!(keyType == null || keyType.canEqual(keyType2) && keyType.equals(keyType2))) {
                throw new UnsupportedOperationException("Key types if input KeyedStreams don't match: " + keyType + " and " + keyType2 + ".");
            }
            transform.setStateKeySelectors(transform.getStateKeySelector1(), keyedInput2.getKeySelector());
            transform.setStateKeyType(keyType2);
        }
        return transform;
    }

    public static <T, R> AbstractDataStream<R> transformOneInputOperator(String operatorName, AbstractDataStream<T> inputStream, TypeInformation<R> outTypeInfo, StreamOperatorFactory<R> operatorFactory) {
        inputStream.getTransformation().getOutputType();
        OneInputTransformation resultTransform = new OneInputTransformation(inputStream.getTransformation(), operatorName, operatorFactory, outTypeInfo, inputStream.getEnvironment().getParallelism(), false);
        NonKeyedPartitionStreamImpl returnStream = new NonKeyedPartitionStreamImpl(inputStream.getEnvironment(), resultTransform);
        inputStream.getEnvironment().addOperator((Transformation<?>)resultTransform);
        return returnStream;
    }

    public static <T> DataStreamV2SinkTransformation<T, T> addSinkOperator(AbstractDataStream<T> inputStream, Sink<T> sink, TypeInformation<T> typeInformation) {
        inputStream.getTransformation().getOutputType();
        if (!(sink instanceof WrappedSink)) {
            throw new UnsupportedOperationException("Unsupported type of sink, please use DataStreamV2SinkUtils to wrap a sink-v2 sink first.");
        }
        org.apache.flink.api.connector.sink2.Sink innerSink = ((WrappedSink)sink).getWrappedSink();
        DataStreamV2SinkTransformation<T, T> sinkTransformation = new DataStreamV2SinkTransformation<T, T>(inputStream, innerSink, typeInformation, "Sink", inputStream.getEnvironment().getParallelism(), false);
        inputStream.getEnvironment().addOperator((Transformation<?>)sinkTransformation);
        return sinkTransformation;
    }

    public static <T> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<T> wrapWithConfigureHandle(NonKeyedPartitionStreamImpl<T> stream) {
        return new ProcessConfigurableAndNonKeyedPartitionStreamImpl<T>(stream);
    }

    public static <K, T> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, T> wrapWithConfigureHandle(KeyedPartitionStreamImpl<K, T> stream) {
        return new ProcessConfigurableAndKeyedPartitionStreamImpl<K, T>(stream);
    }

    public static <T> GlobalStream.ProcessConfigurableAndGlobalStream<T> wrapWithConfigureHandle(GlobalStreamImpl<T> stream) {
        return new ProcessConfigurableAndGlobalStreamImpl<T>(stream);
    }

    public static void validateStates(Set<StateDeclaration> inputStateDeclarations, Set<StateDeclaration.RedistributionMode> invalidStateDeclarations) {
        inputStateDeclarations.stream().map(StateDeclaration::getRedistributionMode).forEach(mode -> {
            if (invalidStateDeclarations.contains(mode)) {
                throw new IllegalRedistributionModeException(mode);
            }
        });
    }
}

