/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CsvRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final SerializationRuntimeConverter runtimeConverter;
    private final CsvMapper csvMapper;
    private final CsvSchema csvSchema;
    private final ObjectWriter objectWriter;
    private transient ObjectNode root;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    private CsvRowDataSerializationSchema(RowType rowType, CsvSchema csvSchema) {
        this.rowType = rowType;
        this.runtimeConverter = this.createRowConverter(rowType);
        this.csvMapper = new CsvMapper();
        this.csvSchema = csvSchema;
        this.objectWriter = this.csvMapper.writer((FormatSchema)csvSchema);
    }

    public byte[] serialize(RowData row) {
        if (this.root == null) {
            this.root = this.csvMapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.csvMapper, (ContainerNode<?>)this.root, row);
            return this.objectWriter.writeValueAsBytes((Object)this.root);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'.", t);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        CsvRowDataSerializationSchema that = (CsvRowDataSerializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.rowType.equals((Object)that.rowType) && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && Arrays.equals(this.csvSchema.getLineSeparator(), otherSchema.getLineSeparator()) && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.rowType, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.getLineSeparator(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    private SerializationRuntimeConverter createRowConverter(RowType type) {
        LogicalType[] fieldTypes = (LogicalType[])type.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        String[] fieldNames = type.getFieldNames().toArray(new String[0]);
        RowFieldConverter[] fieldConverters = (RowFieldConverter[])Arrays.stream(fieldTypes).map(this::createNullableRowFieldConverter).toArray(RowFieldConverter[]::new);
        int rowArity = type.getFieldCount();
        return (csvMapper, container, row) -> {
            ObjectNode objectNode = (ObjectNode)container;
            for (int i = 0; i < rowArity; ++i) {
                objectNode.set(fieldNames[i], fieldConverters[i].convert(csvMapper, container, row, i));
            }
            return objectNode;
        };
    }

    private RowFieldConverter createNullableRowFieldConverter(LogicalType fieldType) {
        RowFieldConverter fieldConverter = this.createRowFieldConverter(fieldType);
        return (csvMapper, container, row, pos) -> {
            if (row.isNullAt(pos)) {
                return container.nullNode();
            }
            return fieldConverter.convert(csvMapper, container, row, pos);
        };
    }

    private RowFieldConverter createRowFieldConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return (csvMapper, container, row, pos) -> container.nullNode();
            }
            case BOOLEAN: {
                return (csvMapper, container, row, pos) -> container.booleanNode(row.getBoolean(pos));
            }
            case TINYINT: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getByte(pos));
            }
            case SMALLINT: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getShort(pos));
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getInt(pos));
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getLong(pos));
            }
            case FLOAT: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getFloat(pos));
            }
            case DOUBLE: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getDouble(pos));
            }
            case CHAR: 
            case VARCHAR: {
                return (csvMapper, container, row, pos) -> container.textNode(row.getString(pos).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (csvMapper, container, row, pos) -> container.binaryNode(row.getBinary(pos));
            }
            case DATE: {
                return (csvMapper, container, row, pos) -> CsvRowDataSerializationSchema.convertDate(row.getInt(pos), container);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (csvMapper, container, row, pos) -> CsvRowDataSerializationSchema.convertTime(row.getInt(pos), container);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                int zonedTimestampPrecision = ((LocalZonedTimestampType)fieldType).getPrecision();
                return (csvMapper, container, row, pos) -> CsvRowDataSerializationSchema.convertTimestamp(row.getTimestamp(pos, zonedTimestampPrecision), container);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)fieldType).getPrecision();
                return (csvMapper, container, row, pos) -> CsvRowDataSerializationSchema.convertTimestamp(row.getTimestamp(pos, timestampPrecision), container);
            }
            case DECIMAL: {
                return this.createDecimalRowFieldConverter((DecimalType)fieldType);
            }
            case ARRAY: {
                return this.createArrayRowFieldConverter((ArrayType)fieldType);
            }
            case ROW: {
                return this.createRowRowFieldConverter((RowType)fieldType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private ArrayElementConverter createNullableArrayElementConverter(LogicalType fieldType) {
        ArrayElementConverter elementConverter = this.createArrayElementConverter(fieldType);
        return (csvMapper, container, array, pos) -> {
            if (array.isNullAt(pos)) {
                return container.nullNode();
            }
            return elementConverter.convert(csvMapper, container, array, pos);
        };
    }

    private ArrayElementConverter createArrayElementConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return (csvMapper, container, array, pos) -> container.nullNode();
            }
            case BOOLEAN: {
                return (csvMapper, container, array, pos) -> container.booleanNode(array.getBoolean(pos));
            }
            case TINYINT: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getByte(pos));
            }
            case SMALLINT: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getShort(pos));
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getInt(pos));
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getLong(pos));
            }
            case FLOAT: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getFloat(pos));
            }
            case DOUBLE: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getDouble(pos));
            }
            case CHAR: 
            case VARCHAR: {
                return (csvMapper, container, array, pos) -> container.textNode(array.getString(pos).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (csvMapper, container, array, pos) -> container.binaryNode(array.getBinary(pos));
            }
            case DATE: {
                return (csvMapper, container, array, pos) -> CsvRowDataSerializationSchema.convertDate(array.getInt(pos), container);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (csvMapper, container, array, pos) -> CsvRowDataSerializationSchema.convertTime(array.getInt(pos), container);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                int zonedTimestampPrecision = ((LocalZonedTimestampType)fieldType).getPrecision();
                return (csvMapper, container, array, pos) -> CsvRowDataSerializationSchema.convertTimestamp(array.getTimestamp(pos, zonedTimestampPrecision), container);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)fieldType).getPrecision();
                return (csvMapper, container, array, pos) -> CsvRowDataSerializationSchema.convertTimestamp(array.getTimestamp(pos, timestampPrecision), container);
            }
            case DECIMAL: {
                return this.createDecimalArrayElementConverter((DecimalType)fieldType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private RowFieldConverter createDecimalRowFieldConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (csvMapper, container, row, pos) -> {
            DecimalData decimal = row.getDecimal(pos, precision, scale);
            return CsvRowDataSerializationSchema.convertDecimal(decimal, container);
        };
    }

    private ArrayElementConverter createDecimalArrayElementConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (csvMapper, container, array, pos) -> {
            DecimalData decimal = array.getDecimal(pos, precision, scale);
            return CsvRowDataSerializationSchema.convertDecimal(decimal, container);
        };
    }

    private static JsonNode convertDecimal(DecimalData decimal, ContainerNode<?> container) {
        return container.numberNode(decimal.toBigDecimal());
    }

    private static JsonNode convertDate(int days, ContainerNode<?> container) {
        LocalDate date = LocalDate.ofEpochDay(days);
        return container.textNode(DateTimeFormatter.ISO_LOCAL_DATE.format(date));
    }

    private static JsonNode convertTime(int millisecond, ContainerNode<?> container) {
        LocalTime time = LocalTime.ofSecondOfDay((long)millisecond / 1000L);
        return container.textNode(DateTimeFormatter.ISO_LOCAL_TIME.format(time));
    }

    private static JsonNode convertTimestamp(TimestampData timestamp, ContainerNode<?> container) {
        return container.textNode(DATE_TIME_FORMATTER.format(timestamp.toLocalDateTime()));
    }

    private RowFieldConverter createArrayRowFieldConverter(ArrayType type) {
        LogicalType elementType = type.getElementType();
        ArrayElementConverter elementConverter = this.createNullableArrayElementConverter(elementType);
        return (csvMapper, container, row, pos) -> {
            ArrayNode arrayNode = csvMapper.createArrayNode();
            ArrayData arrayData = row.getArray(pos);
            int numElements = arrayData.size();
            for (int i = 0; i < numElements; ++i) {
                arrayNode.add(elementConverter.convert(csvMapper, (ContainerNode<?>)arrayNode, arrayData, i));
            }
            return arrayNode;
        };
    }

    private RowFieldConverter createRowRowFieldConverter(RowType type) {
        LogicalType[] fieldTypes = (LogicalType[])type.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        RowFieldConverter[] fieldConverters = (RowFieldConverter[])Arrays.stream(fieldTypes).map(this::createNullableRowFieldConverter).toArray(RowFieldConverter[]::new);
        int rowArity = type.getFieldCount();
        return (csvMapper, container, row, pos) -> {
            RowData value = row.getRow(pos, rowArity);
            ArrayNode arrayNode = csvMapper.createArrayNode();
            for (int i = 0; i < rowArity; ++i) {
                arrayNode.add(fieldConverters[i].convert(csvMapper, (ContainerNode<?>)arrayNode, value, i));
            }
            return arrayNode;
        };
    }

    private static interface ArrayElementConverter
    extends Serializable {
        public JsonNode convert(CsvMapper var1, ContainerNode<?> var2, ArrayData var3, int var4);
    }

    private static interface RowFieldConverter
    extends Serializable {
        public JsonNode convert(CsvMapper var1, ContainerNode<?> var2, RowData var3, int var4);
    }

    private static interface SerializationRuntimeConverter
    extends Serializable {
        public JsonNode convert(CsvMapper var1, ContainerNode<?> var2, RowData var3);
    }

    @PublicEvolving
    public static class Builder {
        private final RowType rowType;
        private CsvSchema csvSchema;

        public Builder(RowType rowType) {
            Preconditions.checkNotNull((Object)rowType, (String)"Row type must not be null.");
            this.rowType = rowType;
            this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        }

        public Builder setFieldDelimiter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(c).build();
            return this;
        }

        public Builder setLineDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Delimiter must not be null.");
            if (!(delimiter.equals("\n") || delimiter.equals("\r") || delimiter.equals("\r\n") || delimiter.equals(""))) {
                throw new IllegalArgumentException("Unsupported new line delimiter. Only \\n, \\r, \\r\\n, or empty string are supported.");
            }
            this.csvSchema = this.csvSchema.rebuild().setLineSeparator(delimiter).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder disableQuoteCharacter() {
            this.csvSchema = this.csvSchema.rebuild().disableQuoteChar().build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String s) {
            this.csvSchema = this.csvSchema.rebuild().setNullValue(s).build();
            return this;
        }

        public CsvRowDataSerializationSchema build() {
            return new CsvRowDataSerializationSchema(this.rowType, this.csvSchema);
        }
    }
}

