/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class CsvRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> resultTypeInfo;
    private final DeserializationRuntimeConverter runtimeConverter;
    private final CsvSchema csvSchema;
    private final ObjectReader objectReader;
    private final boolean ignoreParseErrors;

    private CsvRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, CsvSchema csvSchema, boolean ignoreParseErrors) {
        this.resultTypeInfo = resultTypeInfo;
        this.runtimeConverter = this.createRowConverter(rowType, true);
        this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        this.objectReader = new CsvMapper().readerFor(JsonNode.class).with((FormatSchema)csvSchema);
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public RowData deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = (JsonNode)this.objectReader.readValue(message);
            return (RowData)this.runtimeConverter.convert(root);
        }
        catch (Throwable t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new IOException("Failed to deserialize CSV row '" + new String(message) + "'.", t);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CsvRowDataDeserializationSchema that = (CsvRowDataDeserializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.resultTypeInfo.equals(that.resultTypeInfo) && this.ignoreParseErrors == that.ignoreParseErrors && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && this.csvSchema.allowsComments() == otherSchema.allowsComments() && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.resultTypeInfo, this.ignoreParseErrors, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.allowsComments(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    DeserializationRuntimeConverter createRowConverter(RowType rowType, boolean isTopLevel) {
        DeserializationRuntimeConverter[] fieldConverters = (DeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(this::createNullableConverter).toArray(DeserializationRuntimeConverter[]::new);
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        int arity = fieldNames.length;
        return jsonNode -> {
            int nodeSize = jsonNode.size();
            CsvRowDataDeserializationSchema.validateArity(arity, nodeSize, this.ignoreParseErrors);
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                JsonNode field = isTopLevel ? jsonNode.get(fieldNames[i]) : jsonNode.get(i);
                if (field == null) {
                    row.setField(i, null);
                    continue;
                }
                row.setField(i, fieldConverters[i].convert(field));
            }
            return row;
        };
    }

    private DeserializationRuntimeConverter createNullableConverter(LogicalType type) {
        DeserializationRuntimeConverter converter = this.createConverter(type);
        return jsonNode -> {
            if (jsonNode == null || jsonNode.isNull()) {
                return null;
            }
            try {
                return converter.convert(jsonNode);
            }
            catch (Throwable t) {
                if (!this.ignoreParseErrors) {
                    throw t;
                }
                return null;
            }
        };
    }

    private DeserializationRuntimeConverter createConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return jsonNode -> null;
            }
            case BOOLEAN: {
                return this::convertToBoolean;
            }
            case TINYINT: {
                return jsonNode -> Byte.parseByte(jsonNode.asText().trim());
            }
            case SMALLINT: {
                return jsonNode -> Short.parseShort(jsonNode.asText().trim());
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return this::convertToInt;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return this::convertToLong;
            }
            case DATE: {
                return this::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this::convertToTime;
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this::convertToTimestamp;
            }
            case FLOAT: {
                return this::convertToFloat;
            }
            case DOUBLE: {
                return this::convertToDouble;
            }
            case CHAR: 
            case VARCHAR: {
                return this::convertToString;
            }
            case BINARY: 
            case VARBINARY: {
                return this::convertToBytes;
            }
            case DECIMAL: {
                return this.createDecimalConverter((DecimalType)type);
            }
            case ARRAY: {
                return this.createArrayConverter((ArrayType)type);
            }
            case ROW: {
                return this.createRowConverter((RowType)type, false);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private boolean convertToBoolean(JsonNode jsonNode) {
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        return Boolean.parseBoolean(jsonNode.asText().trim());
    }

    private int convertToInt(JsonNode jsonNode) {
        if (jsonNode.canConvertToInt()) {
            return jsonNode.asInt();
        }
        return Integer.parseInt(jsonNode.asText().trim());
    }

    private long convertToLong(JsonNode jsonNode) {
        if (jsonNode.canConvertToLong()) {
            return jsonNode.asLong();
        }
        return Long.parseLong(jsonNode.asText().trim());
    }

    private double convertToDouble(JsonNode jsonNode) {
        if (jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        return Double.parseDouble(jsonNode.asText().trim());
    }

    private float convertToFloat(JsonNode jsonNode) {
        if (jsonNode.isDouble()) {
            return (float)jsonNode.asDouble();
        }
        return Float.parseFloat(jsonNode.asText().trim());
    }

    private int convertToDate(JsonNode jsonNode) {
        return (int)Date.valueOf(jsonNode.asText()).toLocalDate().toEpochDay();
    }

    private int convertToTime(JsonNode jsonNode) {
        LocalTime localTime = Time.valueOf(jsonNode.asText()).toLocalTime();
        return localTime.toSecondOfDay() * 1000;
    }

    private TimestampData convertToTimestamp(JsonNode jsonNode) {
        Timestamp timestamp = Timestamp.valueOf(jsonNode.asText());
        return TimestampData.fromTimestamp((Timestamp)timestamp);
    }

    private StringData convertToString(JsonNode jsonNode) {
        return StringData.fromString((String)jsonNode.asText());
    }

    private byte[] convertToBytes(JsonNode jsonNode) {
        try {
            return jsonNode.binaryValue();
        }
        catch (IOException e) {
            throw new CsvParseException("Unable to deserialize byte array.", e);
        }
    }

    private DeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return jsonNode -> {
            BigDecimal bigDecimal = jsonNode.isBigDecimal() ? jsonNode.decimalValue() : new BigDecimal(jsonNode.asText());
            return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
        };
    }

    private DeserializationRuntimeConverter createArrayConverter(ArrayType arrayType) {
        DeserializationRuntimeConverter elementConverter = this.createNullableConverter(arrayType.getElementType());
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        return jsonNode -> {
            ArrayNode node = (ArrayNode)jsonNode;
            Object[] array = (Object[])Array.newInstance(elementClass, node.size());
            for (int i = 0; i < node.size(); ++i) {
                JsonNode innerNode = node.get(i);
                array[i] = elementConverter.convert(innerNode);
            }
            return new GenericArrayData(array);
        };
    }

    private static void validateArity(int expected, int actual, boolean ignoreParseErrors) {
        if (expected != actual && !ignoreParseErrors) {
            throw new RuntimeException("Row length mismatch. " + expected + " fields expected but was " + actual + ".");
        }
    }

    private static final class CsvParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CsvParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    static interface DeserializationRuntimeConverter
    extends Serializable {
        public Object convert(JsonNode var1);
    }

    @Internal
    public static class Builder {
        private final RowType rowType;
        private final TypeInformation<RowData> resultTypeInfo;
        private CsvSchema csvSchema;
        private boolean ignoreParseErrors;

        public Builder(RowType rowType, TypeInformation<RowData> resultTypeInfo) {
            Preconditions.checkNotNull((Object)rowType, (String)"RowType must not be null.");
            Preconditions.checkNotNull(resultTypeInfo, (String)"Result type information must not be null.");
            this.rowType = rowType;
            this.resultTypeInfo = resultTypeInfo;
            this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        }

        public Builder setFieldDelimiter(char delimiter) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(delimiter).build();
            return this;
        }

        public Builder setAllowComments(boolean allowComments) {
            this.csvSchema = this.csvSchema.rebuild().setAllowComments(allowComments).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Array element delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String nullLiteral) {
            Preconditions.checkNotNull((Object)nullLiteral, (String)"Null literal must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setNullValue(nullLiteral).build();
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public CsvRowDataDeserializationSchema build() {
            return new CsvRowDataDeserializationSchema(this.rowType, this.resultTypeInfo, this.csvSchema, this.ignoreParseErrors);
        }
    }
}

