/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.tweetinputformat.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.contrib.tweetinputformat.io.TweetHandler;
import org.apache.flink.contrib.tweetinputformat.model.tweet.Tweet;
import org.apache.flink.core.fs.FileInputSplit;
import org.codehaus.jackson.JsonParseException;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTweetInputFormat
extends DelimitedInputFormat<Tweet>
implements ResultTypeQueryable<Tweet> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTweetInputFormat.class);
    private transient JSONParser parser;
    private transient TweetHandler handler;

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.handler = new TweetHandler();
        this.parser = new JSONParser();
    }

    public Tweet nextRecord(Tweet record) throws IOException {
        Boolean result = false;
        do {
            try {
                record.reset(0);
                record = (Tweet)super.nextRecord((Object)record);
                result = true;
            }
            catch (JsonParseException e) {
                result = false;
            }
        } while (!result.booleanValue());
        return record;
    }

    public Tweet readRecord(Tweet reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        InputStreamReader jsonReader = new InputStreamReader(new ByteArrayInputStream(bytes));
        jsonReader.skip(offset);
        try {
            this.handler.reuse = reuse;
            this.parser.parse((Reader)jsonReader, (ContentHandler)this.handler, false);
        }
        catch (ParseException e) {
            LOG.debug(" Tweet Parsing Exception : " + e.getMessage());
        }
        return reuse;
    }

    public TypeInformation<Tweet> getProducedType() {
        return new GenericTypeInfo(Tweet.class);
    }
}

