/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;

class DataStreamIterator<T>
implements Iterator<T> {
    ServerSocket socket;
    InputStream tcpStream;
    T next;
    private final CountDownLatch connectionAccepted = new CountDownLatch(1);
    private volatile StreamReaderDataInputView streamReader;
    private final TypeSerializer<T> serializer;

    DataStreamIterator(TypeSerializer serializer) {
        this.serializer = serializer;
        try {
            this.socket = new ServerSocket(0, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException("DataStreamIterator: an I/O error occurred when opening the socket", e);
        }
        new AcceptThread().start();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.readNextFromStream();
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            this.readNextFromStream();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        T current = this.next;
        this.next = null;
        return current;
    }

    private void readNextFromStream() {
        try {
            this.connectionAccepted.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("The calling thread of DataStreamIterator.readNextFromStream was interrupted.");
        }
        try {
            this.next = this.serializer.deserialize((DataInputView)this.streamReader);
        }
        catch (EOFException e) {
            this.next = null;
        }
        catch (IOException e) {
            throw new RuntimeException("DataStreamIterator could not read from deserializedStream", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class StreamReaderDataInputView
    extends DataInputStream
    implements DataInputView {
        public StreamReaderDataInputView(InputStream stream) {
            super(stream);
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            while (numBytes > 0) {
                int skipped = this.skipBytes(numBytes);
                numBytes -= skipped;
            }
        }
    }

    private class AcceptThread
    extends Thread {
        private AcceptThread() {
        }

        @Override
        public void run() {
            try {
                DataStreamIterator.this.tcpStream = DataStreamIterator.this.socket.accept().getInputStream();
                DataStreamIterator.this.streamReader = new StreamReaderDataInputView(DataStreamIterator.this.tcpStream);
                DataStreamIterator.this.connectionAccepted.countDown();
            }
            catch (IOException e) {
                throw new RuntimeException("DataStreamIterator.AcceptThread failed", e);
            }
        }
    }
}

