/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SocketClientSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollectSink<IN>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SocketClientSink.class);
    private final InetAddress hostIp;
    private final int port;
    private final TypeSerializer<IN> serializer;
    private transient Socket client;
    private transient DataOutputStream dataOutputStream;
    private StreamWriterDataOutputView streamWriter;

    public CollectSink(InetAddress hostIp, int port, TypeSerializer<IN> serializer) {
        this.hostIp = hostIp;
        this.port = port;
        this.serializer = serializer;
    }

    public void initializeConnection() {
        OutputStream outputStream;
        try {
            this.client = new Socket(this.hostIp, this.port);
            outputStream = this.client.getOutputStream();
            this.streamWriter = new StreamWriterDataOutputView(outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    public void invoke(IN value) {
        block2: {
            try {
                this.serializer.serialize(value, (DataOutputView)this.streamWriter);
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Cannot send message to socket server at " + this.hostIp.toString() + ":" + this.port, (Throwable)e);
            }
        }
    }

    private void closeConnection() {
        try {
            this.dataOutputStream.flush();
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing connection with socket server at " + this.hostIp.toString() + ":" + this.port, e);
        }
        finally {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException e) {
                    LOG.error("Cannot close connection with socket server at " + this.hostIp.toString() + ":" + this.port, (Throwable)e);
                }
            }
        }
    }

    public void open(Configuration parameters) {
        this.initializeConnection();
    }

    public void close() {
        this.closeConnection();
    }

    private static class StreamWriterDataOutputView
    extends DataOutputStream
    implements DataOutputView {
        public StreamWriterDataOutputView(OutputStream stream) {
            super(stream);
        }

        public void skipBytesToWrite(int numBytes) throws IOException {
            for (int i = 0; i < numBytes; ++i) {
                this.write(0);
            }
        }

        public void write(DataInputView source, int numBytes) throws IOException {
            byte[] data = new byte[numBytes];
            source.readFully(data);
            this.write(data);
        }
    }
}

