/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.connectors.tidb.table.utils.UriHostMapping;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.tikv.common.TiConfiguration;

public class TDBSourceOptions {
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the TiDB server to monitor.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the TiDB database to monitor.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for TiDB CDC consumer, valid enumerations are \"initial\", \"latest-offset\"");
    public static final ConfigOption<String> PD_ADDRESSES = ConfigOptions.key((String)"pd-addresses").stringType().noDefaultValue().withDescription("TiKV cluster's PD address");
    public static final ConfigOption<String> HOST_MAPPING = ConfigOptions.key((String)"host-mapping").stringType().noDefaultValue().withDescription("TiKV cluster's host-mapping used to configure public IP and intranet IP mapping. When the TiKV cluster is running on the intranet, you can map a set of intranet IPs to public IPs for an outside Flink cluster to access. The format is {Intranet IP1}:{Public IP1};{Intranet IP2}:{Public IP2}, e.g. 192.168.0.2:8.8.8.8;192.168.0.3:9.9.9.9.");
    public static final ConfigOption<Long> TIKV_GRPC_TIMEOUT = ConfigOptions.key((String)"tikv.grpc.timeout_in_ms").longType().noDefaultValue().withDescription("TiKV GRPC timeout in ms");
    public static final ConfigOption<Long> TIKV_GRPC_SCAN_TIMEOUT = ConfigOptions.key((String)"tikv.grpc.scan_timeout_in_ms").longType().noDefaultValue().withDescription("TiKV GRPC scan timeout in ms");
    public static final ConfigOption<Integer> TIKV_BATCH_GET_CONCURRENCY = ConfigOptions.key((String)"tikv.batch_get_concurrency").intType().noDefaultValue().withDescription("TiKV GRPC batch get concurrency");
    public static final ConfigOption<Integer> TIKV_BATCH_SCAN_CONCURRENCY = ConfigOptions.key((String)"tikv.batch_scan_concurrency").intType().noDefaultValue().withDescription("TiKV GRPC batch scan concurrency");

    private TDBSourceOptions() {
    }

    public static TiConfiguration getTiConfiguration(String pdAddrsStr, String hostMapping, Map<String, String> options) {
        Configuration configuration = Configuration.fromMap(options);
        TiConfiguration tiConf = TiConfiguration.createDefault((String)pdAddrsStr);
        Optional.of(new UriHostMapping(hostMapping)).ifPresent(arg_0 -> ((TiConfiguration)tiConf).setHostMapping(arg_0));
        configuration.getOptional(TIKV_GRPC_TIMEOUT).ifPresent(arg_0 -> ((TiConfiguration)tiConf).setTimeout(arg_0));
        configuration.getOptional(TIKV_GRPC_SCAN_TIMEOUT).ifPresent(arg_0 -> ((TiConfiguration)tiConf).setScanTimeout(arg_0));
        configuration.getOptional(TIKV_BATCH_GET_CONCURRENCY).ifPresent(arg_0 -> ((TiConfiguration)tiConf).setBatchGetConcurrency(arg_0));
        configuration.getOptional(TIKV_BATCH_SCAN_CONCURRENCY).ifPresent(arg_0 -> ((TiConfiguration)tiConf).setBatchScanConcurrency(arg_0));
        return tiConf;
    }
}

