/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.HostMapping;

public class UriHostMapping
implements HostMapping {
    private static final Logger LOG = LoggerFactory.getLogger(UriHostMapping.class);
    private final ConcurrentMap<String, String> hostMapping;

    public UriHostMapping(String hostMappingString) {
        if (hostMappingString == null || hostMappingString.isEmpty()) {
            this.hostMapping = null;
            return;
        }
        try {
            this.hostMapping = Arrays.stream(hostMappingString.split(";")).map(s -> {
                String[] hostAndPort = s.split(":");
                return new AbstractMap.SimpleEntry<String, String>(hostAndPort[0], hostAndPort[1]);
            }).collect(Collectors.toConcurrentMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        }
        catch (Exception e) {
            LOG.error("Invalid host mapping string: {}", (Object)hostMappingString, (Object)e);
            throw new IllegalArgumentException("Invalid host mapping string: " + hostMappingString);
        }
    }

    public ConcurrentMap<String, String> getHostMapping() {
        return this.hostMapping;
    }

    public URI getMappedURI(URI uri) {
        if (this.hostMapping != null && this.hostMapping.containsKey(uri.getHost())) {
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), (String)this.hostMapping.get(uri.getHost()), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                LOG.error("Failed to get mapped URI", (Throwable)ex);
                throw new IllegalArgumentException(ex);
            }
        }
        return uri;
    }
}

