/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.tidb.TiKVSnapshotEventDeserializationSchema;
import org.apache.flink.cdc.connectors.tidb.table.RowDataTiKVEventDeserializationSchemaBase;
import org.apache.flink.cdc.connectors.tidb.table.TiKVMetadataConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.tikv.common.TiConfiguration;
import org.tikv.common.codec.TableCodec;
import org.tikv.common.key.RowKey;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.kvproto.Kvrpcpb;

public class RowDataTiKVSnapshotEventDeserializationSchema
extends RowDataTiKVEventDeserializationSchemaBase
implements TiKVSnapshotEventDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> resultTypeInfo;

    public RowDataTiKVSnapshotEventDeserializationSchema(TiConfiguration tiConf, String database, String tableName, TypeInformation<RowData> resultTypeInfo, TiKVMetadataConverter[] metadataConverters, RowType physicalDataType) {
        super(tiConf, database, tableName, metadataConverters, physicalDataType);
        this.resultTypeInfo = (TypeInformation)Preconditions.checkNotNull(resultTypeInfo);
    }

    public TypeInformation getProducedType() {
        return this.resultTypeInfo;
    }

    @Override
    public void deserialize(Kvrpcpb.KvPair record, Collector<RowData> out) throws Exception {
        if (this.tableInfo == null) {
            this.tableInfo = this.fetchTableInfo();
        }
        Object[] tikvValues = TableCodec.decodeObjects((byte[])record.getValue().toByteArray(), (Long)RowKey.decode((byte[])record.getKey().toByteArray()).getHandle(), (TiTableInfo)this.tableInfo);
        this.emit(new TiKVMetadataConverter.TiKVRowValue(record), (RowData)this.physicalConverter.convert(tikvValues, this.tableInfo, null), out);
    }
}

