/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table.utils;

import java.util.HashMap;
import org.apache.flink.cdc.connectors.tidb.TDBSourceOptions;
import org.apache.flink.cdc.connectors.tidb.table.utils.UriHostMapping;
import org.junit.Assert;
import org.junit.Test;
import org.tikv.common.TiConfiguration;

public class UriHostMappingTest {
    @Test
    public void uriHostMappingTest() {
        TiConfiguration tiConf = TDBSourceOptions.getTiConfiguration((String)"http://0.0.0.0:2347", (String)"host1:1;host2:2;host3:3", new HashMap());
        UriHostMapping uriHostMapping = (UriHostMapping)tiConf.getHostMapping();
        Assert.assertEquals((long)uriHostMapping.getHostMapping().size(), (long)3L);
        Assert.assertEquals(uriHostMapping.getHostMapping().get("host1"), (Object)"1");
    }

    @Test
    public void uriHostMappingEmpty() {
        TiConfiguration tiConf = TDBSourceOptions.getTiConfiguration((String)"http://0.0.0.0:2347", (String)"", new HashMap());
        UriHostMapping uriHostMapping = (UriHostMapping)tiConf.getHostMapping();
        Assert.assertEquals((Object)uriHostMapping.getHostMapping(), null);
    }

    @Test
    public void uriHostMappingError() {
        try {
            TiConfiguration tiConfiguration = TDBSourceOptions.getTiConfiguration((String)"http://0.0.0.0:2347", (String)"host1=1;host2=2;host3=3", new HashMap());
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Invalid host mapping string: host1=1;host2=2;host3=3");
        }
    }
}

