/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.connectors.tidb.table.StartupOptions;
import org.apache.flink.cdc.connectors.tidb.table.TiDBTableSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.junit.Assert;
import org.junit.Test;

public class TiDBTableSourceFactoryTest {
    private static final ResolvedSchema SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"aaa", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"bbb", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"ccc", (DataType)DataTypes.DOUBLE()), Column.physical((String)"ddd", (DataType)DataTypes.DECIMAL((int)31, (int)18)), Column.physical((String)"eee", (DataType)DataTypes.TIMESTAMP((int)3))), new ArrayList(), UniqueConstraint.primaryKey((String)"pk", Arrays.asList("bbb", "aaa")));
    private static final ResolvedSchema SCHEMA_WITH_METADATA = new ResolvedSchema(Arrays.asList(Column.physical((String)"id", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"count", (DataType)DataTypes.DECIMAL((int)38, (int)18)), Column.metadata((String)"time", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), (String)"op_ts", (boolean)true), Column.metadata((String)"database_name", (DataType)DataTypes.STRING(), (String)"database_name", (boolean)true), Column.metadata((String)"table_name", (DataType)DataTypes.STRING(), (String)"table_name", (boolean)true), Column.metadata((String)"op_ts", (DataType)DataTypes.TIMESTAMP(), (String)"op_ts", (boolean)true)), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", Collections.singletonList("id")));
    private static final String MY_HOSTNAME = "tidb0:4000";
    private static final String MY_DATABASE = "inventory";
    private static final String MY_TABLE = "products";
    private static final String PD_ADDRESS = "pd0:2379";
    private static final String HOST_MAPPING = "host1:1;host2:2;host3:3";
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();

    @Test
    public void testCommonProperties() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = TiDBTableSourceFactoryTest.createTableSource(properties);
        TiDBTableSource expectedSource = new TiDBTableSource(SCHEMA, MY_DATABASE, MY_TABLE, PD_ADDRESS, HOST_MAPPING, StartupOptions.latest(), OPTIONS);
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testOptionalProperties() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("host-mapping", HOST_MAPPING);
        properties.put("tikv.grpc.timeout_in_ms", "20000");
        properties.put("tikv.grpc.scan_timeout_in_ms", "20000");
        properties.put("tikv.batch_get_concurrency", "4");
        properties.put("tikv.batch_put_concurrency", "4");
        properties.put("tikv.batch_scan_concurrency", "4");
        properties.put("tikv.batch_delete_concurrency", "4");
        DynamicTableSource actualSource = TiDBTableSourceFactoryTest.createTableSource(properties);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("tikv.grpc.timeout_in_ms", "20000");
        options.put("tikv.grpc.scan_timeout_in_ms", "20000");
        options.put("tikv.batch_get_concurrency", "4");
        options.put("tikv.batch_put_concurrency", "4");
        options.put("tikv.batch_scan_concurrency", "4");
        options.put("tikv.batch_delete_concurrency", "4");
        TiDBTableSource expectedSource = new TiDBTableSource(SCHEMA, MY_DATABASE, MY_TABLE, PD_ADDRESS, HOST_MAPPING, StartupOptions.latest(), options);
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    private Map<String, String> getAllOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "tidb-cdc");
        options.put("hostname", MY_HOSTNAME);
        options.put("database-name", MY_DATABASE);
        options.put("table-name", MY_TABLE);
        options.put("pd-addresses", PD_ADDRESS);
        options.put("scan.startup.mode", "latest-offset");
        return options;
    }

    private static DynamicTableSource createTableSource(ResolvedSchema schema, Map<String, String> options) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"default", (String)"default", (String)"t1"), (ResolvedCatalogTable)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)"mock source", new ArrayList(), options), schema), (ReadableConfig)new Configuration(), (ClassLoader)TiDBTableSourceFactoryTest.class.getClassLoader(), (boolean)false);
    }

    private static DynamicTableSource createTableSource(Map<String, String> options) {
        return TiDBTableSourceFactoryTest.createTableSource(SCHEMA, options);
    }
}

