/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.metrics;

import java.util.Optional;
import org.apache.flink.cdc.connectors.tidb.metrics.TiDBSourceMetrics;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.testutils.MetricListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TiDBSourceMetricsTest {
    private MetricListener metricListener;
    private TiDBSourceMetrics sourceMetrics;

    @Before
    public void setUp() {
        this.metricListener = new MetricListener();
        this.sourceMetrics = new TiDBSourceMetrics(this.metricListener.getMetricGroup());
        this.sourceMetrics.registerMetrics();
    }

    @Test
    public void testFetchEventTimeLagTracking() {
        this.sourceMetrics.recordFetchDelay(5L);
        this.assertGauge(this.metricListener, "currentFetchEventTimeLag", 5L);
    }

    @Test
    public void testEmitEventTimeLagTracking() {
        this.sourceMetrics.recordEmitDelay(3L);
        this.assertGauge(this.metricListener, "currentEmitEventTimeLag", 3L);
    }

    private void assertGauge(MetricListener metricListener, String identifier, long expected) {
        Optional gauge = metricListener.getGauge(new String[]{identifier});
        Assert.assertTrue((boolean)gauge.isPresent());
        Assert.assertEquals((long)expected, (long)((Long)((Gauge)gauge.get()).getValue()));
    }
}

