/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb;

import com.alibaba.dcm.DnsCacheManipulator;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomUtils;
import org.apache.flink.test.util.AbstractTestBase;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;

public class TiDBTestBase
extends AbstractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TiDBTestBase.class);
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)--.*$");
    public static final String PD_SERVICE_NAME = "pd0";
    public static final String TIKV_SERVICE_NAME = "tikv0";
    public static final String TIDB_SERVICE_NAME = "tidb0";
    public static final String TIDB_USER = "root";
    public static final String TIDB_PASSWORD = "";
    public static final int TIDB_PORT = 4000;
    public static final int TIKV_PORT_ORIGIN = 20160;
    public static final int PD_PORT_ORIGIN = 2379;
    public static int pdPort = 2379 + RandomUtils.nextInt((int)0, (int)1000);
    @ClassRule
    public static final Network NETWORK = Network.newNetwork();
    @ClassRule
    public static final GenericContainer<?> PD = ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)new FixedHostPortGenericContainer("pingcap/pd:v6.1.0").withFileSystemBind("src/test/resources/config/pd.toml", "/pd.toml")).withFixedExposedPort(pdPort, 2379).withCommand(new String[]{"--name=pd0", "--client-urls=http://0.0.0.0:" + pdPort + ",http://0.0.0.0:2379", "--peer-urls=http://0.0.0.0:2380", "--advertise-client-urls=http://pd0:" + pdPort + ",http://pd0:2379", "--advertise-peer-urls=http://pd0:2380", "--initial-cluster=pd0=http://pd0:2380", "--data-dir=/data/pd0", "--config=/pd.toml", "--log-file=/logs/pd0.log"})).withNetwork(NETWORK)).withNetworkAliases(new String[]{"pd0"})).withStartupTimeout(Duration.ofSeconds(120L))).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    @ClassRule
    public static final GenericContainer<?> TIKV = ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)new FixedHostPortGenericContainer("pingcap/tikv:v6.1.0").withFixedExposedPort(20160, 20160).withFileSystemBind("src/test/resources/config/tikv.toml", "/tikv.toml")).withCommand(new String[]{"--addr=0.0.0.0:20160", "--advertise-addr=tikv0:20160", "--data-dir=/data/tikv0", "--pd=pd0:2379", "--config=/tikv.toml", "--log-file=/logs/tikv0.log"})).withNetwork(NETWORK)).dependsOn(new Startable[]{PD})).withNetworkAliases(new String[]{"tikv0"})).withStartupTimeout(Duration.ofSeconds(120L))).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    @ClassRule
    public static final GenericContainer<?> TIDB = ((GenericContainer)new GenericContainer("pingcap/tidb:v6.1.0").withExposedPorts(new Integer[]{4000}).withFileSystemBind("src/test/resources/config/tidb.toml", "/tidb.toml")).withCommand(new String[]{"--store=tikv", "--path=pd0:2379", "--config=/tidb.toml", "--advertise-address=tidb0"}).withNetwork(NETWORK).dependsOn(new Startable[]{TIKV}).withNetworkAliases(new String[]{"tidb0"}).withStartupTimeout(Duration.ofSeconds(120L)).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));

    @BeforeClass
    public static void startContainers() throws Exception {
        DnsCacheManipulator.setDnsCache((String)PD_SERVICE_NAME, (String[])new String[]{"127.0.0.1"});
        DnsCacheManipulator.setDnsCache((String)TIKV_SERVICE_NAME, (String[])new String[]{"127.0.0.1"});
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(PD, TIKV, TIDB)).join();
        LOG.info("Containers are started.");
    }

    @AfterClass
    public static void stopContainers() {
        DnsCacheManipulator.removeDnsCache((String)PD_SERVICE_NAME);
        DnsCacheManipulator.removeDnsCache((String)TIKV_SERVICE_NAME);
        Stream.of(TIKV, PD, TIDB).forEach(GenericContainer::stop);
    }

    public String getJdbcUrl(String databaseName) {
        return "jdbc:mysql://" + TIDB.getContainerIpAddress() + ":" + TIDB.getMappedPort(4000) + "/" + databaseName;
    }

    protected Connection getJdbcConnection(String databaseName) throws SQLException {
        return DriverManager.getConnection(this.getJdbcUrl(databaseName), TIDB_USER, TIDB_PASSWORD);
    }

    private static void dropTestDatabase(Connection connection, String databaseName) throws SQLException {
        try {
            Awaitility.await((String)String.format("Dropping database %s", databaseName)).atMost(120L, TimeUnit.SECONDS).until(() -> {
                try {
                    String sql = String.format("DROP DATABASE IF EXISTS %s", databaseName);
                    connection.createStatement().execute(sql);
                    return true;
                }
                catch (SQLException e) {
                    LOG.warn(String.format("DROP DATABASE %s failed: {}", databaseName), (Object)e.getMessage());
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException("Failed to drop test database", e);
        }
    }

    protected void initializeTidbTable(String sqlFile) {
        String ddlFile = String.format("ddl/%s.sql", sqlFile);
        URL ddlTestFile = TiDBTestBase.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try (Connection connection = this.getJdbcConnection(TIDB_PASSWORD);
             Statement statement = connection.createStatement();){
            TiDBTestBase.dropTestDatabase(connection, sqlFile);
            List statements = Arrays.stream(Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream().map(String::trim).filter(x -> !x.startsWith("--") && !x.isEmpty()).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).collect(Collectors.joining("\n")).split(";")).collect(Collectors.toList());
            for (String stmt : statements) {
                statement.execute(stmt);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

