/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table.utils;

import java.math.BigInteger;
import java.util.List;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableList;
import org.apache.flink.util.Preconditions;
import org.tikv.common.key.RowKey;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.protobuf.ByteString;

public class TableKeyRangeUtils {
    public static Coprocessor.KeyRange getTableKeyRange(long tableId) {
        return KeyRangeUtils.makeCoprocRange((ByteString)RowKey.createMin((long)tableId).toByteString(), (ByteString)RowKey.createBeyondMax((long)tableId).toByteString());
    }

    public static List<Coprocessor.KeyRange> getTableKeyRanges(long tableId, int num) {
        Preconditions.checkArgument((num > 0 ? 1 : 0) != 0, (Object)"Illegal value of num");
        if (num == 1) {
            return ImmutableList.of((Object)TableKeyRangeUtils.getTableKeyRange(tableId));
        }
        long delta = BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(-9223372036854775807L)).divide(BigInteger.valueOf(num)).longValueExact();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < num; ++i) {
            RowKey startKey = i == 0 ? RowKey.createMin((long)tableId) : RowKey.toRowKey((long)tableId, (long)(Long.MIN_VALUE + delta * (long)i));
            RowKey endKey = i == num - 1 ? RowKey.createBeyondMax((long)tableId) : RowKey.toRowKey((long)tableId, (long)(Long.MIN_VALUE + delta * (long)(i + 1)));
            builder.add((Object)KeyRangeUtils.makeCoprocRange((ByteString)startKey.toByteString(), (ByteString)endKey.toByteString()));
        }
        return builder.build();
    }

    public static Coprocessor.KeyRange getTableKeyRange(long tableId, int num, int idx) {
        Preconditions.checkArgument((idx >= 0 && idx < num ? 1 : 0) != 0, (Object)"Illegal value of idx");
        return TableKeyRangeUtils.getTableKeyRanges(tableId, num).get(idx);
    }

    public static boolean isRecordKey(byte[] key) {
        return key[9] == 95 && key[10] == 114;
    }
}

