/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.tidb.TDBSourceOptions;
import org.apache.flink.cdc.connectors.tidb.table.StartupOptions;
import org.apache.flink.cdc.connectors.tidb.table.TiDBTableSource;
import org.apache.flink.cdc.connectors.tidb.table.utils.OptionUtils;
import org.apache.flink.cdc.debezium.utils.ResolvedSchemaUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class TiDBTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "tidb-cdc";
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        String databaseName = (String)config.get(TDBSourceOptions.DATABASE_NAME);
        String tableName = (String)config.get(TDBSourceOptions.TABLE_NAME);
        String pdAddresses = (String)config.get(TDBSourceOptions.PD_ADDRESSES);
        StartupOptions startupOptions = TiDBTableSourceFactory.getStartupOptions(config);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)context.getCatalogTable().getResolvedSchema());
        OptionUtils.printOptions(IDENTIFIER, ((Configuration)config).toMap());
        return new TiDBTableSource(physicalSchema, databaseName, tableName, pdAddresses, startupOptions, TiKVOptions.getTiKVOptions(context.getCatalogTable().getOptions()));
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(TDBSourceOptions.DATABASE_NAME);
        options.add(TDBSourceOptions.TABLE_NAME);
        options.add(TDBSourceOptions.PD_ADDRESSES);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(TDBSourceOptions.SCAN_STARTUP_MODE);
        options.add(TDBSourceOptions.TIKV_GRPC_TIMEOUT);
        options.add(TDBSourceOptions.TIKV_GRPC_SCAN_TIMEOUT);
        options.add(TDBSourceOptions.TIKV_BATCH_GET_CONCURRENCY);
        options.add(TDBSourceOptions.TIKV_BATCH_SCAN_CONCURRENCY);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(TDBSourceOptions.SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s], but was: %s", TDBSourceOptions.SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }

    static class TiKVOptions {
        private static final String TIKV_OPTIONS_PREFIX = "tikv.";

        TiKVOptions() {
        }

        public static Map<String, String> getTiKVOptions(Map<String, String> properties) {
            HashMap<String, String> tikvOptions = new HashMap<String, String>();
            if (TiKVOptions.hasTiKVOptions(properties)) {
                properties.keySet().stream().filter(key -> key.startsWith(TIKV_OPTIONS_PREFIX)).forEach(key -> {
                    String value = (String)properties.get(key);
                    tikvOptions.put((String)key, value);
                });
            }
            return tikvOptions;
        }

        private static boolean hasTiKVOptions(Map<String, String> options) {
            return options.keySet().stream().anyMatch(k -> k.startsWith(TIKV_OPTIONS_PREFIX));
        }
    }
}

