/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.shaded.guava31.com.google.common.base.Predicates;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.assertj.core.api.AbstractAssert;
import org.junit.jupiter.api.Assertions;

public class UnorderedCollectIteratorAssert<T>
extends AbstractAssert<UnorderedCollectIteratorAssert<T>, Iterator<T>> {
    private final Iterator<T> collectorIterator;
    private final Set<T> allRecords;
    private final Set<T> matchedRecords;
    private Integer limit = null;

    protected UnorderedCollectIteratorAssert(Iterator<T> collectorIterator) {
        super(collectorIterator, UnorderedCollectIteratorAssert.class);
        this.collectorIterator = collectorIterator;
        this.allRecords = new HashSet<T>();
        this.matchedRecords = new HashSet<T>();
    }

    public UnorderedCollectIteratorAssert<T> withNumRecordsLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public void matchesRecordsFromSource(List<List<T>> recordsBySplitsFromSource, CheckpointingMode semantic) {
        for (List<T> list : recordsBySplitsFromSource) {
            for (T t : list) {
                Assertions.assertTrue((boolean)this.allRecords.add(t), (String)"All the records should be unique.");
            }
        }
        if (this.limit != null && this.limit > this.allRecords.size()) {
            throw new IllegalArgumentException("Limit validation size should be less than or equal to total number of records from source");
        }
        switch (semantic) {
            case AT_LEAST_ONCE: {
                this.compareWithAtLeastOnceSemantic();
                break;
            }
            case EXACTLY_ONCE: {
                this.compareWithExactlyOnceSemantic();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized semantic \"" + semantic + "\"");
            }
        }
    }

    private void compareWithAtLeastOnceSemantic() {
        int recordCounter = 0;
        while (this.collectorIterator.hasNext()) {
            T record = this.collectorIterator.next();
            if (this.allRecords.contains(record)) {
                if (this.matchedRecords.add(record)) {
                    ++recordCounter;
                }
            } else {
                throw new IllegalArgumentException("Record " + record + " is not expected.");
            }
            if (this.limit == null || recordCounter < this.limit) continue;
            break;
        }
        this.verifyMatchedRecords();
    }

    private void compareWithExactlyOnceSemantic() {
        int recordCounter = 0;
        while (this.collectorIterator.hasNext()) {
            T record = this.collectorIterator.next();
            if (!this.allRecords.contains(record)) {
                throw new IllegalArgumentException("Record " + record + " is not expected.");
            }
            Assertions.assertTrue((boolean)this.matchedRecords.add(record), (String)("Record " + record + " is duplicated in exactly-once."));
            if (this.limit == null || ++recordCounter < this.limit) continue;
            break;
        }
        this.verifyMatchedRecords();
    }

    private void verifyMatchedRecords() {
        if (this.limit == null && this.allRecords.size() > this.matchedRecords.size()) {
            Set missingResults = this.allRecords.stream().filter(Predicates.not(this.matchedRecords::contains)).collect(Collectors.toSet());
            if (!missingResults.isEmpty()) {
                throw new IllegalArgumentException("Expected to have " + this.allRecords.size() + " elements. But we missing: " + missingResults);
            }
        }
    }
}

