/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.container;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;

public class FlinkContainersSettings {
    private final String baseImage;
    private final int numTaskManagers;
    private final int numSlotsPerTaskManager;
    private final Collection<String> jarPaths;
    private final Configuration flinkConfig;
    private final String taskManagerHostnamePrefix;
    private final Boolean buildFromFlinkDist;
    private final String flinkDistLocation;
    private final String flinkHome;
    private final String checkpointPath;
    private final String haStoragePath;
    private final Boolean zookeeperHA;
    private final String zookeeperHostname;
    private final Properties logProperties;
    private static final long DEFAULT_METRIC_FETCHER_UPDATE_INTERVAL_MS = 1000L;
    private static final long DEFAULT_SLOT_REQUEST_TIMEOUT_MS = 10000L;
    private static final long DEFAULT_HEARTBEAT_TIMEOUT_MS = 5000L;
    private static final long DEFAULT_HEARTBEAT_INTERVAL_MS = 1000L;
    private static final MemorySize DEFAULT_TM_TOTAL_PROCESS_MEMORY = MemorySize.ofMebiBytes((long)1728L);
    private static final MemorySize DEFAULT_JM_TOTAL_PROCESS_MEMORY = MemorySize.ofMebiBytes((long)1600L);
    private static final int DEFAULT_NUM_TASK_MANAGERS = 1;
    private static final int DEFAULT_NUM_SLOTS_PER_TASK_MANAGER = 1;
    private static final String DEFAULT_TASK_MANAGERS_HOSTNAME_PREFIX = "taskmanager-";
    private static final String DEFAULT_JOB_MANAGER_HOSTNAME = "jobmanager";
    private static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_FLINK_HOME = "/opt/flink";
    private static final String DEFAULT_CHECKPOINT_PATH = "/opt/flink/checkpoint";
    private static final String DEFAULT_HA_STORAGE_PATH = "/opt/flink/recovery";
    private static final String DEFAULT_ZOOKEEPER_HOSTNAME = "zookeeper";
    private static final String DEFAULT_ZOOKEEPER_QUORUM = "zookeeper:2181";

    private FlinkContainersSettings(Builder builder) {
        this.baseImage = builder.baseImage;
        this.numTaskManagers = builder.numTaskManagers;
        this.numSlotsPerTaskManager = builder.numSlotsPerTaskManager;
        this.jarPaths = builder.jarPaths;
        this.flinkConfig = builder.flinkConfiguration;
        this.taskManagerHostnamePrefix = builder.taskManagerHostnamePrefix;
        this.buildFromFlinkDist = builder.buildFromFlinkDist;
        this.flinkDistLocation = builder.flinkDistLocation;
        this.flinkHome = builder.flinkHome;
        this.checkpointPath = builder.checkpointPath;
        this.haStoragePath = builder.haStoragePath;
        this.zookeeperHA = builder.zookeeperHA;
        this.zookeeperHostname = builder.zookeeperHostname;
        this.logProperties = builder.logProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static FlinkContainersSettings defaultConfig() {
        return FlinkContainersSettings.builder().build();
    }

    public static FlinkContainersSettings basedOn(Configuration config) {
        return FlinkContainersSettings.builder().basedOn(config).build();
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public int getNumTaskManagers() {
        return this.numTaskManagers;
    }

    public int getNumSlotsPerTaskManager() {
        return this.numSlotsPerTaskManager;
    }

    public Collection<String> getJarPaths() {
        return this.jarPaths;
    }

    public Configuration getFlinkConfig() {
        return this.flinkConfig;
    }

    public String getTaskManagerHostnamePrefix() {
        return this.taskManagerHostnamePrefix;
    }

    public String getJobManagerHostname() {
        return this.flinkConfig.getString(JobManagerOptions.ADDRESS);
    }

    public Boolean isBuildFromFlinkDist() {
        return this.buildFromFlinkDist;
    }

    public String getFlinkDistLocation() {
        return this.flinkDistLocation;
    }

    public String getFlinkHome() {
        return this.flinkHome;
    }

    public String getCheckpointPath() {
        return this.checkpointPath;
    }

    public String getHaStoragePath() {
        return this.haStoragePath;
    }

    public String getHaStoragePathUri() {
        return Paths.get(this.getHaStoragePath(), new String[0]).toUri().toString();
    }

    public static String getDefaultFlinkHome() {
        return DEFAULT_FLINK_HOME;
    }

    public static String getDefaultCheckpointPath() {
        return DEFAULT_CHECKPOINT_PATH;
    }

    public Boolean isZookeeperHA() {
        return this.zookeeperHA;
    }

    public String getZookeeperHostname() {
        return this.zookeeperHostname;
    }

    public Properties getLogProperties() {
        return this.logProperties;
    }

    private static String toUri(String path) {
        return Paths.get(path, new String[0]).toUri().toString();
    }

    public static final class Builder {
        private String baseImage;
        private int numTaskManagers = 1;
        private int numSlotsPerTaskManager = 1;
        private Collection<String> jarPaths = new ArrayList<String>();
        private Configuration flinkConfiguration = this.defaultFlinkConfig();
        private String taskManagerHostnamePrefix = "taskmanager-";
        private Boolean buildFromFlinkDist = true;
        private String flinkDistLocation;
        private String flinkHome = "/opt/flink";
        private String checkpointPath = "/opt/flink/checkpoint";
        private String haStoragePath = "/opt/flink/recovery";
        private Boolean zookeeperHA = false;
        private String zookeeperHostname = "zookeeper";
        private Properties logProperties = this.defaultLoggingProperties();

        private Builder() {
        }

        public Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            this.buildFromFlinkDist = false;
            return this;
        }

        public Builder flinkDistLocation(String flinkDistLocation) {
            this.flinkDistLocation = flinkDistLocation;
            this.buildFromFlinkDist = true;
            return this;
        }

        public Builder flinkHome(String flinkHome) {
            this.flinkHome = flinkHome;
            return this;
        }

        public Builder checkpointPath(String checkpointPath) {
            this.checkpointPath = checkpointPath;
            return this.setConfigOption(CheckpointingOptions.CHECKPOINTS_DIRECTORY, FlinkContainersSettings.toUri(checkpointPath));
        }

        public Builder haStoragePath(String haStoragePath) {
            this.haStoragePath = haStoragePath;
            return this.setConfigOption(HighAvailabilityOptions.HA_STORAGE_PATH, FlinkContainersSettings.toUri(haStoragePath));
        }

        public Builder zookeeperHostname(String zookeeperHostname) {
            this.zookeeperHostname = zookeeperHostname;
            return this;
        }

        public Builder enableZookeeperHA() {
            this.zookeeperHA = true;
            this.setConfigOption(HighAvailabilityOptions.HA_MODE, FlinkContainersSettings.DEFAULT_ZOOKEEPER_HOSTNAME);
            this.setConfigOption(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, FlinkContainersSettings.DEFAULT_ZOOKEEPER_QUORUM);
            this.setConfigOption(HighAvailabilityOptions.HA_CLUSTER_ID, "flink-container-" + UUID.randomUUID());
            this.setConfigOption(HighAvailabilityOptions.HA_STORAGE_PATH, FlinkContainersSettings.toUri(FlinkContainersSettings.DEFAULT_HA_STORAGE_PATH));
            return this;
        }

        public Builder numTaskManagers(int numTaskManagers) {
            this.numTaskManagers = numTaskManagers;
            return this;
        }

        public Builder numSlotsPerTaskManager(int numSlotsPerTaskManager) {
            this.numSlotsPerTaskManager = numSlotsPerTaskManager;
            return this.setConfigOption(TaskManagerOptions.NUM_TASK_SLOTS, numSlotsPerTaskManager);
        }

        public Builder jarPaths(String ... jarPaths) {
            this.jarPaths = Arrays.asList(jarPaths);
            return this;
        }

        public Builder jarPaths(Collection<String> jarPaths) {
            this.jarPaths = jarPaths;
            return this;
        }

        public <T> Builder setConfigOption(ConfigOption<T> option, T value) {
            this.flinkConfiguration.set(option, value);
            return this;
        }

        public Builder setLogProperty(String key, String value) {
            this.logProperties.setProperty(key, value);
            return this;
        }

        public <T> Builder basedOn(Configuration config) {
            this.flinkConfiguration.addAll(config);
            return this;
        }

        public <T> Builder fullConfiguration(Configuration config) {
            this.flinkConfiguration = config;
            return this;
        }

        public Builder taskManagerHostnamePrefix(String taskManagerHostnamePrefix) {
            this.taskManagerHostnamePrefix = taskManagerHostnamePrefix;
            return this;
        }

        public Builder jobManagerHostname(String jobManagerHostname) {
            return this.setConfigOption(JobManagerOptions.ADDRESS, jobManagerHostname);
        }

        private Configuration defaultFlinkConfig() {
            Configuration config = new Configuration();
            config.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)DEFAULT_TM_TOTAL_PROCESS_MEMORY);
            config.set(JobManagerOptions.TOTAL_PROCESS_MEMORY, (Object)DEFAULT_JM_TOTAL_PROCESS_MEMORY);
            config.set(HeartbeatManagerOptions.HEARTBEAT_INTERVAL, (Object)1000L);
            config.set(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT, (Object)5000L);
            config.set(JobManagerOptions.SLOT_REQUEST_TIMEOUT, (Object)10000L);
            config.set(MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL, (Object)1000L);
            config.set(JobManagerOptions.ADDRESS, (Object)FlinkContainersSettings.DEFAULT_JOB_MANAGER_HOSTNAME);
            config.set(RestOptions.BIND_ADDRESS, (Object)FlinkContainersSettings.DEFAULT_BIND_ADDRESS);
            config.set(TaskManagerOptions.BIND_HOST, (Object)FlinkContainersSettings.DEFAULT_BIND_ADDRESS);
            config.set(JobManagerOptions.BIND_HOST, (Object)FlinkContainersSettings.DEFAULT_BIND_ADDRESS);
            config.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)FlinkContainersSettings.toUri(FlinkContainersSettings.DEFAULT_CHECKPOINT_PATH));
            return config;
        }

        private Properties defaultLoggingProperties() {
            Properties logProperties = new Properties();
            logProperties.setProperty("appender.rolling.strategy.max", "${env:MAX_LOG_FILE_NUMBER:-10}");
            logProperties.setProperty("appender.rolling.policies.size.size", "100MB");
            logProperties.setProperty("logger.zookeeper.name", "org.apache.zookeeper");
            logProperties.setProperty("logger.shaded_zookeeper.name", "org.apache.flink.shaded.zookeeper3");
            logProperties.setProperty("logger.zookeeper.level", "INFO");
            logProperties.setProperty("appender.console.name", "ConsoleAppender");
            logProperties.setProperty("appender.rolling.fileName", "${sys:log.file}");
            logProperties.setProperty("appender.rolling.filePattern", "${sys:log.file}.%i");
            logProperties.setProperty("rootLogger.appenderRef.rolling.ref", "RollingFileAppender");
            logProperties.setProperty("logger.pekko.name", "org.apache.pekko");
            logProperties.setProperty("appender.console.type", "CONSOLE");
            logProperties.setProperty("appender.rolling.append", "true");
            logProperties.setProperty("appender.console.layout.type", "PatternLayout");
            logProperties.setProperty("appender.rolling.name", "RollingFileAppender");
            logProperties.setProperty("rootLogger.appenderRef.console.ref", "ConsoleAppender");
            logProperties.setProperty("appender.rolling.policies.size.type", "SizeBasedTriggeringPolicy");
            logProperties.setProperty("appender.console.layout.pattern", "%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p %-60c %x - %m%n");
            logProperties.setProperty("rootLogger.level", "INFO");
            logProperties.setProperty("logger.hadoop.name", "org.apache.hadoop");
            logProperties.setProperty("logger.shaded_zookeeper.level", "INFO");
            logProperties.setProperty("appender.rolling.layout.type", "PatternLayout");
            logProperties.setProperty("logger.kafka.name", "org.apache.kafka");
            logProperties.setProperty("logger.netty.level", "OFF");
            logProperties.setProperty("appender.rolling.type", "RollingFile");
            logProperties.setProperty("logger.pekko.level", "INFO");
            logProperties.setProperty("logger.hadoop.level", "INFO");
            logProperties.setProperty("appender.rolling.layout.pattern", "%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p %-60c %x - %m%n");
            logProperties.setProperty("appender.rolling.policies.startup.type", "OnStartupTriggeringPolicy");
            logProperties.setProperty("logger.netty.name", "org.jboss.netty.channel.DefaultChannelPipeline");
            logProperties.setProperty("appender.rolling.strategy.type", "DefaultRolloverStrategy");
            logProperties.setProperty("appender.rolling.policies.type", "Policies");
            logProperties.setProperty("monitorInterval", "30");
            logProperties.setProperty("logger.kafka.level", "INFO");
            return logProperties;
        }

        public FlinkContainersSettings build() {
            return new FlinkContainersSettings(this);
        }
    }
}

