/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testutils.source.reader;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;

public class TestingReaderContext
implements SourceReaderContext {
    private final MetricGroup metrics;
    private final Configuration config;
    private final ArrayList<SourceEvent> sentEvents = new ArrayList();
    private int numSplitRequests;

    public TestingReaderContext() {
        this(new Configuration(), (MetricGroup)new UnregisteredMetricsGroup());
    }

    public TestingReaderContext(Configuration config, MetricGroup metricGroup) {
        this.config = config;
        this.metrics = metricGroup;
    }

    public MetricGroup metricGroup() {
        return this.metrics;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public String getLocalHostName() {
        return "localhost";
    }

    public int getIndexOfSubtask() {
        return 0;
    }

    public void sendSplitRequest() {
        ++this.numSplitRequests;
    }

    public void sendSourceEventToCoordinator(SourceEvent sourceEvent) {
        this.sentEvents.add(sourceEvent);
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return SimpleUserCodeClassLoader.create((ClassLoader)this.getClass().getClassLoader());
    }

    public int getNumSplitRequests() {
        return this.numSplitRequests;
    }

    public List<SourceEvent> getSentEvents() {
        return new ArrayList<SourceEvent>(this.sentEvents);
    }

    public void clearSentEvents() {
        this.sentEvents.clear();
    }
}

