/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.table;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.connector.sqs.sink.SqsSink;
import org.apache.flink.connector.sqs.sink.SqsSinkBuilder;
import org.apache.flink.connector.sqs.sink.SqsSinkElementConverter;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;

@Internal
public class SqsDynamicSink
extends AsyncDynamicTableSink<SendMessageBatchRequestEntry> {
    private final DataType consumedDataType;
    private final String sqsUrl;
    private final Properties sqsClientProps;
    EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    private final Boolean failOnError;

    protected SqsDynamicSink(@Nullable Integer maxBatchSize, @Nullable Integer maxInFlightRequests, @Nullable Integer maxBufferedRequests, @Nullable Long maxBufferSizeInBytes, @Nullable Long maxTimeInBufferMS, @Nullable Boolean failOnError, @Nullable DataType consumedDataType, EncodingFormat<SerializationSchema<RowData>> encodingFormat, String sqsUrl, @Nullable Properties sqsClientProps) {
        super(maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBufferSizeInBytes, maxTimeInBufferMS);
        Preconditions.checkNotNull(encodingFormat, (String)"Encoding format must not be null when creating SQS sink.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)sqsUrl) ? 1 : 0) != 0, (Object)"Sqs url must not be null or empty when creating SQS sink.");
        this.consumedDataType = consumedDataType;
        this.sqsUrl = sqsUrl;
        this.sqsClientProps = sqsClientProps;
        this.failOnError = failOnError;
        this.encodingFormat = encodingFormat;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        return this.encodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SqsSinkBuilder builder = SqsSink.builder();
        builder.setSqsUrl(this.sqsUrl);
        Optional.ofNullable(this.sqsClientProps).ifPresent(builder::setSqsClientProperties);
        builder.setSqsSinkElementConverter(SqsSinkElementConverter.builder().setSerializationSchema((SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.consumedDataType)).build());
        Optional.ofNullable(this.failOnError).ifPresent(builder::setFailOnError);
        return SinkV2Provider.of((Sink)builder.build());
    }

    public DynamicTableSink copy() {
        return new SqsDynamicSink(this.maxBatchSize, this.maxInFlightRequests, this.maxBufferedRequests, this.maxBufferSizeInBytes, this.maxTimeInBufferMS, this.failOnError, this.consumedDataType, this.encodingFormat, this.sqsUrl, this.sqsClientProps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqsDynamicSink that = (SqsDynamicSink)((Object)o);
        return super.equals(o) && this.failOnError == that.failOnError && Objects.equals(this.consumedDataType, that.consumedDataType) && Objects.equals(this.sqsUrl, that.sqsUrl) && Objects.equals(this.sqsClientProps, that.sqsClientProps) && Objects.equals(this.encodingFormat, that.encodingFormat);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consumedDataType, this.sqsUrl, this.sqsClientProps, this.encodingFormat, this.failOnError);
    }

    public String asSummaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SqsDynamicSink{");
        sb.append("sqsUrl='").append(this.sqsUrl).append('\'');
        sb.append(", consumedDataType=").append(this.consumedDataType);
        sb.append(", encodingFormat=").append(this.encodingFormat);
        sb.append(", failOnError=").append(this.failOnError);
        Optional.ofNullable(this.sqsClientProps).ifPresent(props -> props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sb.append(", ").append(k).append("=").append(v))));
        sb.append(", maxBatchSize=").append(this.maxBatchSize);
        sb.append(", maxInFlightRequests=").append(this.maxInFlightRequests);
        sb.append(", maxBufferedRequests=").append(this.maxBufferedRequests);
        sb.append(", maxBufferSizeInBytes=").append(this.maxBufferSizeInBytes);
        sb.append(", maxTimeInBufferMS=").append(this.maxTimeInBufferMS);
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        return this.asSummaryString();
    }

    public static SqsQueueUrlConfigurator builder() {
        return new SqsDynamicSinkBuilder();
    }

    @Internal
    public static interface SqsSinkEncodingFormatConfigurator {
        public SqsDynamicSinkBuilder setEncodingFormat(EncodingFormat<SerializationSchema<RowData>> var1);
    }

    @Internal
    public static interface SqsQueueUrlConfigurator {
        public SqsSinkEncodingFormatConfigurator setSqsQueueUrl(String var1);
    }

    @Internal
    public static class SqsDynamicSinkBuilder
    extends AsyncDynamicTableSinkBuilder<SendMessageBatchRequestEntry, SqsDynamicSinkBuilder>
    implements SqsQueueUrlConfigurator,
    SqsSinkEncodingFormatConfigurator {
        private String sqsUrl;
        private Properties sqsClientProps;
        private EncodingFormat<SerializationSchema<RowData>> encodingFormat;
        private Boolean failOnError;
        private DataType consumedDataType;

        @Override
        public SqsSinkEncodingFormatConfigurator setSqsQueueUrl(String sqsUrl) {
            this.sqsUrl = sqsUrl;
            return this;
        }

        @Override
        public SqsDynamicSinkBuilder setEncodingFormat(EncodingFormat<SerializationSchema<RowData>> encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public SqsDynamicSinkBuilder setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public SqsDynamicSinkBuilder setSqsClientProperties(Properties sqsClientProps) {
            this.sqsClientProps = sqsClientProps;
            return this;
        }

        public SqsDynamicSinkBuilder setConsumedDataType(DataType consumedDataType) {
            this.consumedDataType = consumedDataType;
            return this;
        }

        public SqsDynamicSink build() {
            return new SqsDynamicSink(this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBufferSizeInBytes(), this.getMaxTimeInBufferMS(), this.failOnError, this.consumedDataType, this.encodingFormat, this.sqsUrl, this.sqsClientProps);
        }
    }
}

