/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.sink.client;

import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.aws.util.AWSClientUtil;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.connector.sqs.sink.SqsConfigConstants;
import org.apache.flink.connector.sqs.sink.client.SdkClientProvider;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Internal
public class SqsAsyncClientProvider
implements SdkClientProvider<SqsAsyncClient> {
    private final SdkAsyncHttpClient httpClient;
    private final SqsAsyncClient sqsAsyncClient;

    public SqsAsyncClientProvider(Properties clientProperties) {
        this.httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)clientProperties);
        this.sqsAsyncClient = this.buildClient(clientProperties, this.httpClient);
    }

    @Override
    public SqsAsyncClient getClient() {
        return this.sqsAsyncClient;
    }

    public void close() {
        AWSGeneralUtil.closeResources((SdkAutoCloseable[])new SdkAutoCloseable[]{this.httpClient, this.sqsAsyncClient});
    }

    private SqsAsyncClient buildClient(Properties sqsClientProperties, SdkAsyncHttpClient httpClient) {
        AWSGeneralUtil.validateAwsCredentials((Properties)sqsClientProperties);
        return (SqsAsyncClient)AWSClientUtil.createAwsAsyncClient((Properties)sqsClientProperties, (SdkAsyncHttpClient)httpClient, (AwsAsyncClientBuilder)SqsAsyncClient.builder(), (String)SqsConfigConstants.BASE_SQS_USER_AGENT_PREFIX_FORMAT.key(), (String)SqsConfigConstants.SQS_CLIENT_USER_AGENT_PREFIX.key());
    }
}

