/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.sink;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.sink.writer.AsyncSinkWriterStateSerializer;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;

@Internal
public class SqsStateSerializer
extends AsyncSinkWriterStateSerializer<SendMessageBatchRequestEntry> {
    protected void serializeRequestToStream(SendMessageBatchRequestEntry request, DataOutputStream out) throws IOException {
        out.write(request.messageBody().getBytes(StandardCharsets.UTF_8));
        this.serializeRequestId(request.id(), out);
    }

    protected void serializeRequestId(String requestId, DataOutputStream out) throws IOException {
        out.writeInt(requestId.length());
        out.write(requestId.getBytes(StandardCharsets.UTF_8));
    }

    protected SendMessageBatchRequestEntry deserializeRequestFromStream(long requestSize, DataInputStream in) throws IOException {
        byte[] requestData = new byte[(int)requestSize];
        in.read(requestData);
        return (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(this.deserializeRequestId(in)).messageBody(new String(requestData, StandardCharsets.UTF_8)).build();
    }

    protected String deserializeRequestId(DataInputStream in) throws IOException {
        int requestIdLength = in.readInt();
        byte[] requestIdData = new byte[requestIdLength];
        in.read(requestIdData);
        return new String(requestIdData, StandardCharsets.UTF_8);
    }

    public int getVersion() {
        return 1;
    }
}

