/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.sink;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;

@Internal
public class SqsSinkElementConverter<InputT>
implements ElementConverter<InputT, SendMessageBatchRequestEntry> {
    private final SerializationSchema<InputT> serializationSchema;

    private SqsSinkElementConverter(SerializationSchema<InputT> serializationSchema) {
        this.serializationSchema = serializationSchema;
    }

    public SendMessageBatchRequestEntry apply(InputT element, SinkWriter.Context context) {
        byte[] messageBody = this.serializationSchema.serialize(element);
        return (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(UUID.randomUUID().toString()).messageBody(new String(messageBody, StandardCharsets.UTF_8)).build();
    }

    public void open(Sink.InitContext context) {
        try {
            this.serializationSchema.open(context.asSerializationSchemaInitializationContext());
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to initialize serialization schema.", (Throwable)e);
        }
    }

    public static <InputT> Builder<InputT> builder() {
        return new Builder();
    }

    public static class Builder<InputT> {
        private SerializationSchema<InputT> serializationSchema;

        public Builder<InputT> setSerializationSchema(SerializationSchema<InputT> serializationSchema) {
            this.serializationSchema = serializationSchema;
            return this;
        }

        public SqsSinkElementConverter<InputT> build() {
            Preconditions.checkNotNull(this.serializationSchema, (String)"No SerializationSchema was supplied to the SQS Sink builder.");
            return new SqsSinkElementConverter(this.serializationSchema);
        }
    }
}

