/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.sink;

import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.connector.base.sink.AsyncSinkBaseBuilder;
import org.apache.flink.connector.sqs.sink.SqsSink;
import org.apache.flink.connector.sqs.sink.SqsSinkElementConverter;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;

@PublicEvolving
public class SqsSinkBuilder<InputT>
extends AsyncSinkBaseBuilder<InputT, SendMessageBatchRequestEntry, SqsSinkBuilder<InputT>> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 10;
    private static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS = 50;
    private static final int DEFAULT_MAX_BUFFERED_REQUESTS = 5000;
    private static final long DEFAULT_MAX_BATCH_SIZE_IN_B = 256000L;
    private static final long DEFAULT_MAX_TIME_IN_BUFFER_MS = 5000L;
    private static final long DEFAULT_MAX_RECORD_SIZE_IN_B = 256000L;
    private static final boolean DEFAULT_FAIL_ON_ERROR = false;
    private static final Protocol DEFAULT_HTTP_PROTOCOL = Protocol.HTTP1_1;
    private Boolean failOnError;
    private String sqsUrl;
    private Properties sqsClientProperties;
    private SqsSinkElementConverter<InputT> sqsSinkElementConverter;

    SqsSinkBuilder() {
    }

    public SqsSinkBuilder<InputT> setSqsUrl(String sqsUrl) {
        this.sqsUrl = sqsUrl;
        return this;
    }

    public SqsSinkBuilder<InputT> setSqsSinkElementConverter(SqsSinkElementConverter<InputT> sqsSinkElementConverter) {
        this.sqsSinkElementConverter = sqsSinkElementConverter;
        return this;
    }

    public SqsSinkBuilder<InputT> setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public SqsSinkBuilder<InputT> setSqsClientProperties(Properties sqsClientProps) {
        this.sqsClientProperties = sqsClientProps;
        return this;
    }

    @VisibleForTesting
    Properties getClientPropertiesWithDefaultHttpProtocol() {
        Properties clientProperties = Optional.ofNullable(this.sqsClientProperties).orElse(new Properties());
        clientProperties.putIfAbsent("aws.http.protocol.version", DEFAULT_HTTP_PROTOCOL.toString());
        return clientProperties;
    }

    public SqsSink<InputT> build() {
        return new SqsSink(Optional.ofNullable(this.sqsSinkElementConverter).orElse(SqsSinkElementConverter.builder().setSerializationSchema(new SimpleStringSchema()).build()), Optional.ofNullable(this.getMaxBatchSize()).orElse(10), Optional.ofNullable(this.getMaxInFlightRequests()).orElse(50), Optional.ofNullable(this.getMaxBufferedRequests()).orElse(5000), Optional.ofNullable(this.getMaxBatchSizeInBytes()).orElse(256000L), Optional.ofNullable(this.getMaxTimeInBufferMS()).orElse(5000L), Optional.ofNullable(this.getMaxRecordSizeInBytes()).orElse(256000L), Optional.ofNullable(this.failOnError).orElse(false), this.sqsUrl, this.getClientPropertiesWithDefaultHttpProtocol());
    }
}

