/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.sqs.sink.SqsSinkBuilder;
import org.apache.flink.connector.sqs.sink.SqsSinkWriter;
import org.apache.flink.connector.sqs.sink.SqsStateSerializer;
import org.apache.flink.connector.sqs.sink.client.SdkClientProvider;
import org.apache.flink.connector.sqs.sink.client.SqsAsyncClientProvider;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;

@PublicEvolving
public class SqsSink<InputT>
extends AsyncSinkBase<InputT, SendMessageBatchRequestEntry> {
    private final boolean failOnError;
    private final String sqsUrl;
    private final Properties sqsClientProperties;
    private transient SdkClientProvider<SqsAsyncClient> asyncClientSdkClientProviderOverride;

    SqsSink(ElementConverter<InputT, SendMessageBatchRequestEntry> elementConverter, Integer maxBatchSize, Integer maxInFlightRequests, Integer maxBufferedRequests, Long maxBatchSizeInBytes, Long maxTimeInBufferMS, Long maxRecordSizeInBytes, boolean failOnError, String sqsUrl, Properties sqsClientProperties) {
        super(elementConverter, maxBatchSize.intValue(), maxInFlightRequests.intValue(), maxBufferedRequests.intValue(), maxBatchSizeInBytes.longValue(), maxTimeInBufferMS.longValue(), maxRecordSizeInBytes.longValue());
        this.sqsUrl = (String)Preconditions.checkNotNull((Object)sqsUrl, (String)"The sqs url must not be null when initializing the SQS Sink.");
        Preconditions.checkArgument((!this.sqsUrl.isEmpty() ? 1 : 0) != 0, (Object)"The sqs url must be set when initializing the SQS Sink.");
        Preconditions.checkArgument((this.getMaxBatchSize() <= 10 ? 1 : 0) != 0, (Object)"The sqs MaxBatchSize must not be greater than 10.");
        this.failOnError = failOnError;
        this.sqsClientProperties = sqsClientProperties;
    }

    public static <InputT> SqsSinkBuilder<InputT> builder() {
        return new SqsSinkBuilder();
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<SendMessageBatchRequestEntry>> createWriter(Sink.InitContext context) throws IOException {
        return new SqsSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.sqsUrl, this.getAsyncClientProvider(this.sqsClientProperties), Collections.emptyList());
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<SendMessageBatchRequestEntry>> restoreWriter(Sink.InitContext context, Collection<BufferedRequestState<SendMessageBatchRequestEntry>> recoveredState) throws IOException {
        return new SqsSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.sqsUrl, this.getAsyncClientProvider(this.sqsClientProperties), recoveredState);
    }

    private SdkClientProvider<SqsAsyncClient> getAsyncClientProvider(Properties clientProperties) {
        if (this.asyncClientSdkClientProviderOverride != null) {
            return this.asyncClientSdkClientProviderOverride;
        }
        return new SqsAsyncClientProvider(clientProperties);
    }

    @Internal
    @VisibleForTesting
    void setSqsAsyncClientProvider(SdkClientProvider<SqsAsyncClient> asyncClientSdkClientProviderOverride) {
        this.asyncClientSdkClientProviderOverride = asyncClientSdkClientProviderOverride;
    }

    public SimpleVersionedSerializer<BufferedRequestState<SendMessageBatchRequestEntry>> getWriterStateSerializer() {
        return new SqsStateSerializer();
    }
}

