/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.sqs.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.aws.sink.throwable.AWSExceptionClassifierUtil;
import org.apache.flink.connector.base.sink.throwable.FatalExceptionClassifier;
import org.apache.flink.connector.sqs.sink.SqsSinkException;
import software.amazon.awssdk.services.sqs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sqs.model.SqsException;

@Internal
public class SqsExceptionClassifiers {
    public static FatalExceptionClassifier getNotAuthorizedExceptionClassifier() {
        return AWSExceptionClassifierUtil.withAWSServiceErrorCode(SqsException.class, (String)"NotAuthorized", err -> new SqsSinkException("Encountered non-recoverable exception: NotAuthorized", (Throwable)err));
    }

    public static FatalExceptionClassifier getAccessDeniedExceptionClassifier() {
        return AWSExceptionClassifierUtil.withAWSServiceErrorCode(SqsException.class, (String)"AccessDeniedException", err -> new SqsSinkException("Encountered non-recoverable exception: AccessDeniedException", (Throwable)err));
    }

    public static FatalExceptionClassifier getResourceNotFoundExceptionClassifier() {
        return FatalExceptionClassifier.withRootCauseOfType(ResourceNotFoundException.class, err -> new SqsSinkException("Encountered non-recoverable exception relating to not being able to find the specified resources", (Throwable)err));
    }
}

