/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.dialect;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import org.apache.flink.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.flink.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import org.apache.flink.cdc.connectors.base.source.assigner.state.ChunkSplitterState;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.config.SqlServerSourceConfig;
import org.apache.flink.cdc.connectors.sqlserver.source.dialect.SqlServerChunkSplitter;
import org.apache.flink.cdc.connectors.sqlserver.source.dialect.SqlServerPooledDataSourceFactory;
import org.apache.flink.cdc.connectors.sqlserver.source.dialect.SqlServerSchema;
import org.apache.flink.cdc.connectors.sqlserver.source.offset.LsnOffset;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerScanFetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerSourceFetchTaskContext;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerStreamFetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerConnectionUtils;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerUtils;
import org.apache.flink.util.FlinkRuntimeException;

@Experimental
public class SqlServerDialect
implements JdbcDataSourceDialect {
    private static final long serialVersionUID = 1L;
    private final SqlServerSourceConfig sourceConfig;
    private transient Tables.TableFilter filters;
    private transient SqlServerSchema sqlserverSchema;

    public SqlServerDialect(SqlServerSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public String getName() {
        return "SqlServer";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Offset displayCurrentOffset(JdbcSourceConfig sourceConfig) {
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            LsnOffset lsnOffset = SqlServerUtils.currentLsn((SqlServerConnection)jdbcConnection);
            return lsnOffset;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Read the redoLog offset error", (Throwable)e);
        }
    }

    public boolean isDataCollectionIdCaseSensitive(JdbcSourceConfig sourceConfig) {
        return true;
    }

    public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        return SqlServerConnectionUtils.createSqlServerConnection(sourceConfig.getDbzConnectorConfig());
    }

    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig) {
        return new SqlServerChunkSplitter(sourceConfig, this, ChunkSplitterState.NO_SPLITTING_TABLE_STATE);
    }

    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig, ChunkSplitterState chunkSplitterState) {
        return new SqlServerChunkSplitter(sourceConfig, this, chunkSplitterState);
    }

    public JdbcConnectionPoolFactory getPooledDataSourceFactory() {
        return new SqlServerPooledDataSourceFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TableId> discoverDataCollections(JdbcSourceConfig sourceConfig) {
        SqlServerSourceConfig sqlserverSourceConfig = (SqlServerSourceConfig)sourceConfig;
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            List<TableId> list = SqlServerConnectionUtils.listTables(jdbcConnection, sqlserverSourceConfig.getTableFilters(), sqlserverSourceConfig.getDatabaseList());
            return list;
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error to discover tables: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<TableId, TableChanges.TableChange> discoverDataCollectionSchemas(JdbcSourceConfig sourceConfig) {
        List<TableId> capturedTableIds = this.discoverDataCollections(sourceConfig);
        try (SqlServerConnection jdbc = SqlServerConnectionUtils.createSqlServerConnection(sourceConfig.getDbzConnectorConfig());){
            HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
            for (TableId tableId : capturedTableIds) {
                TableChanges.TableChange tableSchema = this.queryTableSchema((JdbcConnection)jdbc, tableId);
                tableSchemas.put(tableId, tableSchema);
            }
            HashMap<TableId, TableChanges.TableChange> hashMap = tableSchemas;
            return hashMap;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error to discover table schemas: " + e.getMessage(), (Throwable)e);
        }
    }

    public TableChanges.TableChange queryTableSchema(JdbcConnection jdbc, TableId tableId) {
        if (this.sqlserverSchema == null) {
            this.sqlserverSchema = new SqlServerSchema();
        }
        return this.sqlserverSchema.getTableSchema(jdbc, tableId, this.sourceConfig.getDbzConnectorConfig().getTableFilters().dataCollectionFilter());
    }

    public SqlServerSourceFetchTaskContext createFetchTaskContext(JdbcSourceConfig taskSourceConfig) {
        SqlServerConnection jdbcConnection = SqlServerConnectionUtils.createSqlServerConnection((RelationalDatabaseConnectorConfig)this.sourceConfig.getDbzConnectorConfig());
        SqlServerConnection metaDataConnection = SqlServerConnectionUtils.createSqlServerConnection((RelationalDatabaseConnectorConfig)this.sourceConfig.getDbzConnectorConfig());
        return new SqlServerSourceFetchTaskContext(taskSourceConfig, this, jdbcConnection, metaDataConnection);
    }

    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase sourceSplitBase) {
        if (sourceSplitBase.isSnapshotSplit()) {
            return new SqlServerScanFetchTask(sourceSplitBase.asSnapshotSplit());
        }
        return new SqlServerStreamFetchTask(sourceSplitBase.asStreamSplit());
    }

    public boolean isIncludeDataCollection(JdbcSourceConfig sourceConfig, TableId tableId) {
        if (this.filters == null) {
            this.filters = sourceConfig.getTableFilters().dataCollectionFilter();
        }
        return this.filters.isIncluded(tableId);
    }
}

