/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.source;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.connector.pulsar.table.source.PulsarReadableMetadata;
import org.apache.flink.connector.pulsar.table.source.PulsarRowDataConverter;
import org.apache.flink.connector.pulsar.table.source.PulsarTableDeserializationSchema;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

public class PulsarTableDeserializationSchemaFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DataType physicalDataType;
    @Nullable
    private final DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat;
    private final int[] keyProjection;
    private final DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat;
    private final int[] valueProjection;
    private DataType producedDataType;
    private List<String> connectorMetadataKeys;
    private final boolean upsertMode;

    public PulsarTableDeserializationSchemaFactory(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, int[] keyProjection, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] valueProjection, boolean upsertMode) {
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"field physicalDataType must not be null.");
        this.keyDecodingFormat = keyDecodingFormat;
        this.keyProjection = (int[])Preconditions.checkNotNull((Object)keyProjection);
        this.valueDecodingFormat = (DecodingFormat)Preconditions.checkNotNull(valueDecodingFormat, (String)"field valueDecodingFormat must not be null.");
        this.valueProjection = (int[])Preconditions.checkNotNull((Object)valueProjection, (String)"field valueProjection must not be null.");
        this.producedDataType = physicalDataType;
        this.connectorMetadataKeys = Collections.emptyList();
        this.upsertMode = upsertMode;
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = Projection.of((int[])projection).project(this.physicalDataType);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (DeserializationSchema)format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    public PulsarDeserializationSchema<RowData> createPulsarDeserialization(ScanTableSource.ScanContext context) {
        DeserializationSchema<RowData> keyDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.keyDecodingFormat, this.keyProjection, "");
        DeserializationSchema<RowData> valueDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.valueDecodingFormat, this.valueProjection, "");
        TypeInformation producedTypeInfo = context.createTypeInformation(this.producedDataType);
        PulsarReadableMetadata readableMetadata = new PulsarReadableMetadata(this.connectorMetadataKeys);
        int physicalPlusFormatMetadataArity = DataType.getFieldDataTypes((DataType)this.producedDataType).size() - readableMetadata.getConnectorMetadataArity();
        int[] physicalValuePlusFormatMetadataProjection = this.adjustValueProjectionByAppendConnectorMetadata(physicalPlusFormatMetadataArity);
        PulsarRowDataConverter rowDataConverter = new PulsarRowDataConverter(physicalPlusFormatMetadataArity, this.keyProjection, physicalValuePlusFormatMetadataProjection, readableMetadata, this.upsertMode);
        return new PulsarTableDeserializationSchema(keyDeserialization, valueDeserialization, (TypeInformation<RowData>)producedTypeInfo, rowDataConverter, this.upsertMode);
    }

    public void setProducedDataType(DataType producedDataType) {
        this.producedDataType = producedDataType;
    }

    public void setConnectorMetadataKeys(List<String> metadataKeys) {
        this.connectorMetadataKeys = metadataKeys;
    }

    private int[] adjustValueProjectionByAppendConnectorMetadata(int physicalValuePlusFormatMetadataArity) {
        int[] physicalValuePlusFormatMetadataProjection = IntStream.concat(IntStream.of(this.valueProjection), IntStream.range(this.keyProjection.length + this.valueProjection.length, physicalValuePlusFormatMetadataArity)).toArray();
        return physicalValuePlusFormatMetadataProjection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarTableDeserializationSchemaFactory that = (PulsarTableDeserializationSchemaFactory)o;
        return Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.keyDecodingFormat, that.keyDecodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Objects.equals(this.valueDecodingFormat, that.valueDecodingFormat) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.connectorMetadataKeys, that.connectorMetadataKeys) && Objects.equals(this.upsertMode, that.upsertMode);
    }

    public int hashCode() {
        int result = Objects.hash(this.physicalDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.producedDataType, this.connectorMetadataKeys, this.upsertMode);
        result = 31 * result + Arrays.hashCode(this.keyProjection);
        result = 31 * result + Arrays.hashCode(this.valueProjection);
        return result;
    }
}

