/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.split;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.pulsar.common.utils.PulsarSerdeUtils;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;

public class PulsarPartitionSplitSerializer
implements SimpleVersionedSerializer<PulsarPartitionSplit> {
    public static final PulsarPartitionSplitSerializer INSTANCE = new PulsarPartitionSplitSerializer();
    public static final int CURRENT_VERSION = 2;

    private PulsarPartitionSplitSerializer() {
    }

    public int getVersion() {
        return 2;
    }

    /*
     * Exception decompiling
     */
    public byte[] serialize(PulsarPartitionSplit obj) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public PulsarPartitionSplit deserialize(int version, byte[] serialized) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void serializePulsarPartitionSplit(DataOutputStream out, PulsarPartitionSplit split) throws IOException {
        this.serializeTopicPartition(out, split.getPartition());
        PulsarSerdeUtils.serializeObject(out, split.getStopCursor());
        MessageId latestConsumedId = split.getLatestConsumedId();
        if (latestConsumedId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            PulsarSerdeUtils.serializeBytes(out, latestConsumedId.toByteArray());
        }
        TxnID uncommittedTransactionId = split.getUncommittedTransactionId();
        if (uncommittedTransactionId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(uncommittedTransactionId.getMostSigBits());
            out.writeLong(uncommittedTransactionId.getLeastSigBits());
        }
    }

    public PulsarPartitionSplit deserializePulsarPartitionSplit(int version, DataInputStream in) throws IOException {
        TopicPartition partition = this.deserializeTopicPartition(version, in);
        StopCursor stopCursor = (StopCursor)PulsarSerdeUtils.deserializeObject(in);
        MessageId latestConsumedId = null;
        if (in.readBoolean()) {
            byte[] messageIdBytes = PulsarSerdeUtils.deserializeBytes(in);
            latestConsumedId = MessageId.fromByteArray((byte[])messageIdBytes);
        }
        TxnID uncommittedTransactionId = null;
        if (in.readBoolean()) {
            long mostSigBits = in.readLong();
            long leastSigBits = in.readLong();
            uncommittedTransactionId = new TxnID(mostSigBits, leastSigBits);
        }
        return new PulsarPartitionSplit(partition, stopCursor, latestConsumedId, uncommittedTransactionId);
    }

    public void serializeTopicPartition(DataOutputStream out, TopicPartition partition) throws IOException {
        out.writeUTF(partition.getTopic());
        out.writeInt(partition.getPartitionId());
        PulsarSerdeUtils.serializeList(out, partition.getRanges(), (o, r) -> {
            o.writeInt(r.getStart());
            o.writeInt(r.getEnd());
        });
    }

    public TopicPartition deserializeTopicPartition(int version, DataInputStream in) throws IOException {
        List<TopicRange> ranges;
        String topic = in.readUTF();
        int partitionId = in.readInt();
        if (version == 0) {
            int start = in.readInt();
            int end = in.readInt();
            TopicRange range = new TopicRange(start, end);
            ranges = Collections.singletonList(range);
        } else {
            ranges = PulsarSerdeUtils.deserializeList(in, i -> {
                int start = i.readInt();
                int end = i.readInt();
                return new TopicRange(start, end);
            });
            if (version == 1) {
                in.readInt();
            }
        }
        return new TopicPartition(topic, partitionId, ranges);
    }
}

