/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.deserializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;

@Internal
public class PulsarTypeInformationWrapper<T>
implements PulsarDeserializationSchema<T> {
    private static final long serialVersionUID = 6647084180084963022L;
    private static final ThreadLocal<DataInputDeserializer> DESERIALIZER = ThreadLocal.withInitial(DataInputDeserializer::new);
    private final TypeInformation<T> information;
    private final TypeSerializer<T> serializer;

    public PulsarTypeInformationWrapper(TypeInformation<T> information, ExecutionConfig config) {
        this.information = information;
        this.serializer = information.createSerializer(config);
    }

    @Override
    public void deserialize(Message<byte[]> message, Collector<T> out) throws Exception {
        DataInputDeserializer dis = DESERIALIZER.get();
        dis.setBuffer(message.getData());
        Object instance = this.serializer.deserialize((DataInputView)dis);
        out.collect(instance);
    }

    public TypeInformation<T> getProducedType() {
        return this.information;
    }
}

